/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.gitbash.repository;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.oomph.gitbash.AbstractAction;
import org.eclipse.oomph.gitbash.Activator;
import org.eclipse.oomph.util.MonitorUtil;
import org.eclipse.swt.widgets.Shell;

public class PushDirectAction
extends AbstractAction<Repository> {
    public PushDirectAction() {
        super(Repository.class);
    }

    @Override
    protected void run(Shell shell, final Repository repository) throws Exception {
        new Job("Pushing directly"){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(this.getName(), 101);
                try {
                    Git git = Git.wrap((Repository)repository);
                    monitor.worked(1);
                    git.push().setRemote("direct").setProgressMonitor((ProgressMonitor)new EclipseGitProgressTransformer((IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)50))).call();
                    monitor.setTaskName("Pulling");
                    git.pull().setProgressMonitor((ProgressMonitor)new EclipseGitProgressTransformer((IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)50))).call();
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (Exception ex) {
                    IStatus iStatus = Activator.getStatus(ex);
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }
        }.schedule();
    }
}

