/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.embedded;

import java.util.ResourceBundle;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.xtext.ui.editor.embedded.TextViewerAction;

public class TextViewerJoinLinesAction
extends TextViewerAction {
    private String fJoint = null;

    public TextViewerJoinLinesAction(ResourceBundle bundle, String prefix, ITextViewer viewer, String joint) {
        super(bundle, prefix, viewer);
        Assert.isLegal((joint != null ? 1 : 0) != 0);
        this.fJoint = joint;
        this.update();
    }

    public void run() {
        ITextViewer viewer = this.getTextViewer();
        if (viewer == null) {
            return;
        }
        if (!this.canModifyViewer()) {
            return;
        }
        IDocument document = viewer.getDocument();
        if (document == null) {
            return;
        }
        ITextSelection selection = this.getSelection(viewer);
        if (selection == null) {
            return;
        }
        int startLine = selection.getStartLine();
        int endLine = selection.getEndLine();
        try {
            int caretOffset = this.joinLines(document, startLine, endLine);
            if (caretOffset > -1) {
                StyledText widget = viewer.getTextWidget();
                widget.setRedraw(false);
                this.adjustHighlightRange(viewer, caretOffset, 0);
                viewer.revealRange(caretOffset, 0);
                viewer.setSelectedRange(caretOffset, 0);
                widget.setRedraw(true);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    protected void adjustHighlightRange(ITextViewer viewer, int offset, int length) {
        if (viewer == null) {
            return;
        }
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            extension.exposeModelRange((IRegion)new Region(offset, length));
        } else if (!this.isVisible(viewer, offset, length)) {
            viewer.resetVisibleRegion();
        }
    }

    protected boolean isVisible(ITextViewer viewer, int offset, int length) {
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            IRegion overlap = extension.modelRange2WidgetRange((IRegion)new Region(offset, length));
            return overlap != null;
        }
        return viewer.overlapsWithVisibleRegion(offset, length);
    }

    @Override
    public void update() {
        super.update();
        if (!this.isEnabled()) {
            return;
        }
        if (!this.canModifyViewer()) {
            this.setEnabled(false);
            return;
        }
        ITextViewer viewer = this.getTextViewer();
        this.setEnabled(viewer.isEditable());
    }

    private int joinLines(IDocument document, int startLine, int endLine) throws BadLocationException {
        if (startLine == document.getNumberOfLines() - 1) {
            return -1;
        }
        if (startLine == endLine) {
            ++endLine;
        }
        StringBuffer buffer = new StringBuffer();
        int line = startLine;
        while (line <= endLine) {
            buffer.append(this.trim(document, line, line == startLine));
            if (line != endLine) {
                buffer.append(this.fJoint);
            }
            ++line;
        }
        int startLineOffset = document.getLineOffset(startLine);
        int endLineOffset = document.getLineOffset(endLine) + document.getLineLength(endLine) - this.getLineDelimiterLength(document, endLine);
        String replaceString = buffer.toString();
        document.replace(startLineOffset, endLineOffset - startLineOffset, replaceString);
        return startLineOffset + replaceString.length();
    }

    /*
     * Unable to fully structure code
     */
    private String trim(IDocument document, int line, boolean ignoreLeadingWhitespace) throws BadLocationException {
        lineOffset = document.getLineOffset(line);
        lineLength = document.getLineLength(line);
        lineLength -= this.getLineDelimiterLength(document, line);
        if (ignoreLeadingWhitespace) ** GOTO lbl7
        return document.get(lineOffset, lineLength).trim();
lbl-1000:
        // 1 sources

        {
            --lineLength;
lbl7:
            // 2 sources

            ** while (lineLength > 0 && Character.isWhitespace((char)document.getChar((int)(lineOffset + lineLength - 1))))
        }
lbl8:
        // 1 sources

        return document.get(lineOffset, lineLength);
    }

    private int getLineDelimiterLength(IDocument document, int line) throws BadLocationException {
        String lineDelimiter = document.getLineDelimiter(line);
        return lineDelimiter != null ? lineDelimiter.length() : 0;
    }
}

