/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.features.progress;

import com.google.inject.Inject;
import java.util.UUID;
import org.eclipse.glsp.server.actions.ActionDispatcher;
import org.eclipse.glsp.server.actions.UpdateProgressAction;
import org.eclipse.glsp.server.features.progress.EndProgressAction;
import org.eclipse.glsp.server.features.progress.ProgressMonitor;
import org.eclipse.glsp.server.features.progress.ProgressService;
import org.eclipse.glsp.server.features.progress.StartProgressAction;

public class DefaultProgressService
implements ProgressService {
    @Inject
    protected ActionDispatcher actionDispatcher;

    @Override
    public ProgressMonitor start(String title, String message, int percentage) {
        final String progressId = UUID.randomUUID().toString();
        this.actionDispatcher.dispatch(new StartProgressAction(progressId, title, message, percentage));
        return new ProgressMonitor(){

            @Override
            public void update(String message, int percentage) {
                DefaultProgressService.this.actionDispatcher.dispatch(new UpdateProgressAction(progressId, message, percentage));
            }

            @Override
            public void end() {
                DefaultProgressService.this.actionDispatcher.dispatch(new EndProgressAction(progressId));
            }
        };
    }
}

