/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.dctools.ast;

import org.eclipse.etrice.core.fsm.fSM.DetailCode;
import org.eclipse.etrice.core.room.MessageData;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.dctools.ast.DCLinker;
import org.eclipse.etrice.dctools.ast.ITranslationProvider;
import org.eclipse.etrice.dctools.ast.internal.DCTranslatorVisitor;
import org.eclipse.etrice.dctools.fsm.ast.DCLanguage;
import org.eclipse.etrice.dctools.fsm.ast.DCParser;
import org.eclipse.etrice.dctools.fsm.ast.nodes.DCAstMatchNode;
import org.eclipse.etrice.dctools.fsm.ast.util.IDCAstNodeVisitor;
import org.eclipse.etrice.generator.fsm.generic.IDetailCodeTranslator;
import org.eclipse.xtext.xbase.lib.Extension;

public class DCTranslator
implements IDetailCodeTranslator {
    private DCLanguage language;
    private ITranslationProvider translationProvider;
    @Extension
    private final RoomHelpers roomHelpers = new RoomHelpers();

    public DCTranslator(DCLanguage language, ITranslationProvider translationProvider) {
        this.language = language;
        this.translationProvider = translationProvider;
    }

    public String getTranslatedCode(DetailCode dc) {
        return this.getTranslatedCode(dc, null);
    }

    public String getTranslatedCode(DetailCode dc, MessageData transitionData) {
        String code = this.roomHelpers.getDetailCode(dc);
        boolean bl = this.translationProvider.translateTags();
        if (bl) {
            code = this.translateTags(code, dc);
        }
        DCParser parser = new DCParser(this.language);
        DCAstMatchNode ast = parser.parse(code);
        DCLinker linker = new DCLinker(dc, transitionData);
        ast.visit((IDCAstNodeVisitor)linker);
        DCTranslatorVisitor visitor = new DCTranslatorVisitor(this.translationProvider);
        ast.visit((IDCAstNodeVisitor)visitor);
        return visitor.getTranslatedCode();
    }

    public String translateTags(String text, DetailCode dc) {
        StringBuilder result = new StringBuilder();
        int last = 0;
        int next = text.indexOf("<|", last);
        while (next >= 0) {
            int n;
            int n2;
            result.append(text.substring(last, next));
            int n3 = "<|".length();
            last = n2 = next + n3;
            next = text.indexOf("|>", last);
            if (next < 0) continue;
            String tag = text.substring(last, next);
            result.append(this.translationProvider.translateTag(tag, dc));
            int n4 = "|>".length();
            last = n = next + n4;
            next = text.indexOf("<|", last);
        }
        result.append(text.substring(last));
        return result.toString();
    }
}

