/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.genmodel;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.common.validation.ICustomValidator;
import org.eclipse.etrice.core.genmodel.builder.GeneratorModelBuilder;
import org.eclipse.etrice.core.genmodel.builder.GeneratorModelBuilderFactory;
import org.eclipse.etrice.core.genmodel.fsm.IDiagnostician;
import org.eclipse.etrice.core.room.LogicalSystem;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.generator.base.logging.ILogger;
import org.eclipse.etrice.generator.base.logging.NullLogger;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;

public class RoomGenmodelValidator
implements ICustomValidator {
    private static final Set<EClass> classesToCheck = new HashSet<EClass>();
    @Inject
    private GeneratorModelBuilderFactory genModelBuilderFactory;

    public RoomGenmodelValidator() {
        classesToCheck.add(RoomPackage.Literals.ROOM_MODEL);
        classesToCheck.add(RoomPackage.Literals.SUB_SYSTEM_CLASS);
    }

    public String getName() {
        return "Genmodel Validator";
    }

    public String getDescription() {
        return "This validator checks ROOM models by creating actual system instances, which covers aspects like wiring.";
    }

    public Set<EClass> getClassesToCheck() {
        return classesToCheck;
    }

    public void validate(EObject object, ValidationMessageAcceptor messageAcceptor, ICustomValidator.ValidationContext context) {
        if (!this.getClassesToCheck().contains(object.eClass())) {
            return;
        }
        if (context.isGeneration()) {
            return;
        }
        if (object instanceof RoomModel) {
            ResourceSet rs;
            RoomModel model = (RoomModel)object;
            ArrayList<RoomModel> models = new ArrayList<RoomModel>();
            ArrayList<RoomModel> importedModels = new ArrayList<RoomModel>();
            models.add(model);
            Resource resource = model.eResource();
            if (resource != null && (rs = resource.getResourceSet()) != null) {
                EcoreUtil.resolveAll((ResourceSet)rs);
                for (Resource res : rs.getResources()) {
                    for (EObject obj : res.getContents()) {
                        if (!(obj instanceof RoomModel) || obj == model) continue;
                        importedModels.add((RoomModel)obj);
                    }
                }
            }
            Diag diagnostician = new Diag(messageAcceptor);
            GeneratorModelBuilder builder = this.genModelBuilderFactory.create((ILogger)new NullLogger(), diagnostician);
            boolean containsSystem = model.getRoomClasses().stream().anyMatch(LogicalSystem.class::isInstance);
            builder.createGeneratorModel(models, importedModels, containsSystem);
        }
    }

    private class Diag
    implements IDiagnostician {
        private ValidationMessageAcceptor acceptor;

        private Diag(ValidationMessageAcceptor acceptor) {
            this.acceptor = acceptor;
        }

        public void warning(String msg, EObject source, EStructuralFeature feature) {
            this.acceptor.acceptWarning(msg, source, feature, -1, null, new String[0]);
        }

        public void warning(String msg, EObject source, EStructuralFeature feature, int index) {
            this.acceptor.acceptWarning(msg, source, feature, index, null, new String[0]);
        }

        public void error(String msg, EObject source, EStructuralFeature feature) {
            this.acceptor.acceptError(msg, source, feature, -1, null, new String[0]);
        }

        public void error(String msg, EObject source, EStructuralFeature feature, int index) {
            this.acceptor.acceptError(msg, source, feature, index, null, new String[0]);
        }

        public boolean isFailed() {
            return false;
        }
    }
}

