/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.converter;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

public class CCStringIndentation {
    private static final Pattern lineSeparatorPattern = new Functions.Function0<Pattern>(){

        public Pattern apply() {
            StringConcatenation stringConcatenation = new StringConcatenation();
            stringConcatenation.append("(\\r(\\n)?|\\n)");
            Pattern pattern = Pattern.compile(stringConcatenation.toString());
            return pattern;
        }
    }.apply();
    private final String ccString;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private final ImmutableList<String> splittedLines;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private final boolean ignoreFirst;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private final boolean ignoreLast;

    public static boolean hasLineBreak(String nodeText) {
        int n = Strings.countLineBreaks((CharSequence)nodeText);
        return n > 0;
    }

    public static String firstLineSeparator(String it) {
        boolean bl;
        int n;
        boolean bl2;
        String string = null;
        boolean bl3 = false;
        int n2 = it.indexOf("\r\n");
        boolean bl4 = bl2 = n2 >= 0;
        if (bl2) {
            bl3 = true;
            string = "\r\n";
        }
        if (!bl3) {
            n = it.indexOf("\n");
            boolean bl5 = bl = n >= 0;
            if (bl) {
                bl3 = true;
                string = "\n";
            }
        }
        if (!bl3) {
            n = it.indexOf("\r");
            boolean bl6 = bl = n >= 0;
            if (bl) {
                bl3 = true;
                string = "\r";
            }
        }
        if (!bl3) {
            string = Strings.newLine();
        }
        return string;
    }

    public CCStringIndentation(String ccString) {
        this.ccString = ccString;
        ArrayList arrayList = CollectionLiterals.newArrayList();
        Procedures.Procedure1 procedure1 = lines -> {
            boolean bl;
            Matcher matcher = lineSeparatorPattern.matcher(ccString);
            int lastOffset = 0;
            while (matcher.find()) {
                String string2 = ccString.substring(lastOffset, matcher.end());
                lines.add(string2);
                lastOffset = matcher.end();
            }
            int n = ccString.length();
            boolean bl2 = bl = lastOffset < n;
            if (bl) {
                String string3 = ccString.substring(lastOffset);
                lines.add(string3);
            } else if (ccString.endsWith("\n") || ccString.endsWith("\r")) {
                lines.add("");
            }
        };
        ArrayList arrayList2 = (ArrayList)ObjectExtensions.operator_doubleArrow((Object)arrayList, (Procedures.Procedure1)procedure1);
        this.splittedLines = ImmutableList.copyOf((Collection)arrayList2);
        this.ignoreFirst = this.splittedLines.size() >= 2 && ((String)IterableExtensions.head(this.splittedLines)).trim().isEmpty();
        this.ignoreLast = this.splittedLines.size() >= 2 && ((String)IterableExtensions.lastOrNull(this.splittedLines)).trim().isEmpty();
    }

    public String removeEditorWhiteSpace() {
        return this.removeEditorWhiteSpace("", null);
    }

    protected String removeEditorWhiteSpace(String indent, String lineSeparator) {
        Functions.Function1 function1 = offsetLength -> {
            Integer n = (Integer)offsetLength.getKey();
            Integer n2 = (Integer)offsetLength.getValue();
            int n3 = n + n2;
            String string2 = this.ccString.substring((Integer)offsetLength.getKey(), n3);
            return indent + string2;
        };
        Functions.Function1 function12 = it -> this.replaceLineBreak((String)it, lineSeparator);
        return IterableExtensions.join((Iterable)ListExtensions.map((List)ListExtensions.map(this.highlight(), (Functions.Function1)function1), (Functions.Function1)function12));
    }

    public boolean canRemoveEditorIndentation() {
        return this.splittedLines.size() >= 2 && this.ignoreFirst && this.hasConsistentIndentation();
    }

    public String replaceEditorIndentation(String indentation, String lineSeparator) {
        Object object = null;
        if (indentation != null && this.canRemoveEditorIndentation()) {
            String string;
            String string2 = null;
            String string3 = null;
            if (this.ignoreFirst && this.splittedLines.size() > 2) {
                String string4 = null;
                if (lineSeparator != null) {
                    string4 = lineSeparator;
                } else {
                    string = (String)IterableExtensions.head(this.splittedLines);
                    String string5 = null;
                    if (string != null) {
                        string5 = CCStringIndentation.firstLineSeparator(string);
                    }
                    string4 = string5;
                }
                string3 = string4;
            } else {
                string3 = "";
            }
            String addFirstLine = string3;
            string = this.removeEditorWhiteSpace(indentation, lineSeparator);
            string2 = addFirstLine + string;
            object = string2;
        } else {
            String string = null;
            ArrayList arrayList = CollectionLiterals.newArrayList((Object[])((String[])Conversions.unwrapArray(this.splittedLines, String.class)));
            Procedures.Procedure1 procedure1 = it -> {
                if (this.ignoreFirst) {
                    it.set(0, CCStringIndentation.firstLineSeparator((String)IterableExtensions.head((Iterable)it)));
                }
                if (this.ignoreLast) {
                    int n = it.size();
                    int n2 = n - 1;
                    it.remove(n2);
                }
            };
            ArrayList lines = (ArrayList)ObjectExtensions.operator_doubleArrow((Object)arrayList, (Procedures.Procedure1)procedure1);
            Functions.Function1 function1 = it -> this.replaceLineBreak((String)it, lineSeparator);
            string = IterableExtensions.join((Iterable)ListExtensions.map((List)lines, (Functions.Function1)function1));
            object = string;
        }
        return object;
    }

    private String replaceLineBreak(String line, String newLineSeparator) {
        Object object = null;
        if (newLineSeparator != null && Strings.countLineBreaks((CharSequence)line) > 0) {
            CharSequence charSequence = Strings.trimTrailingLineBreak((CharSequence)line);
            object = String.valueOf(charSequence) + newLineSeparator;
        } else {
            object = line;
        }
        return object;
    }

    public List<Pair<Integer, Integer>> highlight() {
        ArrayList offsetLengthLines = CollectionLiterals.newArrayList();
        String editorIndent = this.computeEditorIndent(false);
        int skip = editorIndent.length();
        int offset = 0;
        int i = 0;
        while (i < ((Object[])Conversions.unwrapArray(this.splittedLines, Object.class)).length) {
            String line = (String)this.splittedLines.get(i);
            if (i == 0 && this.ignoreFirst) {
                int n = offset;
                var8_9 = line.length();
                offset = n + var8_9;
            } else if (i != this.splittedLines.size() - 1 || !this.ignoreLast) {
                int n;
                int n2;
                Pair pair = null;
                var8_9 = line.startsWith(editorIndent) ? 1 : 0;
                if (var8_9 != 0) {
                    n2 = line.length();
                    n = n2 - skip;
                    pair = Pair.of((Object)(offset + skip), (Object)n);
                } else {
                    n2 = line.length();
                    pair = Pair.of((Object)offset, (Object)n2);
                }
                offsetLengthLines.add(pair);
                n2 = offset;
                n = line.length();
                offset = n2 + n;
            }
            ++i;
        }
        return offsetLengthLines;
    }

    public boolean hasConsistentIndentation() {
        String string = this.computeEditorIndent(true);
        return string != null;
    }

    protected String computeEditorIndent(boolean consistentOnly) {
        Functions.Function1 function1;
        String string = null;
        if (this.splittedLines.size() <= 1 || !this.ignoreFirst) {
            return "";
        }
        List list = null;
        int n = 0;
        n = this.ignoreFirst ? 1 : 0;
        int begin = n;
        int n2 = this.splittedLines.size();
        int n3 = 0;
        n3 = this.ignoreLast ? 1 : 0;
        int end = n2 - n3;
        Functions.Function1 function12 = it -> Strings.trimTrailingLineBreak((CharSequence)it).toString();
        Functions.Function1 function13 = line -> {
            String string = Strings.getLeadingWhiteSpace((String)line);
            return Pair.of((Object)string, (Object)line);
        };
        List wsLinePairs = list = IterableExtensions.toList((Iterable)ListExtensions.map(ListExtensions.map(this.splittedLines, (Functions.Function1)function12).subList(begin, end), (Functions.Function1)function13));
        Functions.Function1 minWSComputor = function1 = it -> {
            String string = null;
            boolean bl = IterableExtensions.isEmpty((Iterable)it);
            string = bl ? "" : (String)((Object)IterableExtensions.min((Iterable)it));
            return string;
        };
        Functions.Function1 function14 = it -> {
            boolean bl = ((String)it.getValue()).trim().isEmpty();
            return !bl;
        };
        Functions.Function1 function15 = it -> (String)it.getKey();
        String textIndent = (String)minWSComputor.apply((Object)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)wsLinePairs, (Functions.Function1)function14), (Functions.Function1)function15));
        function13 = it -> (String)it.getKey();
        Functions.Function1 function16 = it -> {
            boolean bl = it.isEmpty();
            return !bl;
        };
        Functions.Function1 function17 = nonEmptyIndent -> nonEmptyIndent.startsWith(textIndent);
        boolean consistent = IterableExtensions.forall((Iterable)IterableExtensions.filter((Iterable)ListExtensions.map((List)wsLinePairs, (Functions.Function1)function13), (Functions.Function1)function16), (Functions.Function1)function17);
        String string2 = null;
        boolean bl = false;
        if (consistent) {
            bl = true;
            string2 = textIndent;
        }
        if (!bl && consistentOnly) {
            bl = true;
            string2 = null;
        }
        if (!bl) {
            Functions.Function1 function18 = it -> (String)it.getKey();
            Functions.Function1 function19 = it -> {
                boolean bl = it.isEmpty();
                return !bl;
            };
            string2 = (String)minWSComputor.apply((Object)IterableExtensions.filter((Iterable)ListExtensions.map((List)wsLinePairs, (Functions.Function1)function18), (Functions.Function1)function19));
        }
        string = string2;
        return string;
    }

    @Pure
    public ImmutableList<String> getSplittedLines() {
        return this.splittedLines;
    }

    @Pure
    public boolean isIgnoreFirst() {
        return this.ignoreFirst;
    }

    @Pure
    public boolean isIgnoreLast() {
        return this.ignoreLast;
    }
}

