/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.multilevel.ciftodmm;

import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import org.eclipse.escet.cif.multilevel.ciftodmm.OwnedAndAccessedElements;
import org.eclipse.escet.common.java.BitSets;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;

public class DisjunctGroupsBuilder {
    private DisjunctGroupsBuilder() {
    }

    public static List<OwnedAndAccessedElements> createPlantGroups(Collection<OwnedAndAccessedElements> elements) {
        BiPredicate<OwnedAndAccessedElements, OwnedAndAccessedElements> checkPlantShareRelation = (rel1, rel2) -> rel1.ownedElements.intersects(rel2.accessedElements) || rel1.accessedElements.intersects(rel2.ownedElements) || rel1.accessedElements.intersects(rel2.accessedElements);
        return Lists.set2list(DisjunctGroupsBuilder.createGroups(elements, checkPlantShareRelation));
    }

    public static List<OwnedAndAccessedElements> createRequirementGroups(Collection<OwnedAndAccessedElements> elements, BitSet irrelevantAccess) {
        return Lists.set2list(DisjunctGroupsBuilder.createGroups(elements, new RequirementsShareRelation(irrelevantAccess)));
    }

    private static Set<OwnedAndAccessedElements> createGroups(Collection<OwnedAndAccessedElements> elements, BiPredicate<OwnedAndAccessedElements, OwnedAndAccessedElements> hasSharedRelation) {
        Set nonSharingGroups = Sets.set();
        for (OwnedAndAccessedElements element : elements) {
            OwnedAndAccessedElements newElement = null;
            Iterator nonSharingGroupIter = nonSharingGroups.iterator();
            while (nonSharingGroupIter.hasNext()) {
                OwnedAndAccessedElements nonSharingGroup = (OwnedAndAccessedElements)nonSharingGroupIter.next();
                if (!hasSharedRelation.test(element, nonSharingGroup)) continue;
                if (newElement == null) {
                    newElement = new OwnedAndAccessedElements(element);
                }
                newElement.merge(nonSharingGroup);
                nonSharingGroupIter.remove();
            }
            nonSharingGroups.add(newElement == null ? element : newElement);
        }
        return nonSharingGroups;
    }

    private static class RequirementsShareRelation
    implements BiPredicate<OwnedAndAccessedElements, OwnedAndAccessedElements> {
        private final BitSet irrelevantAccesses;

        public RequirementsShareRelation(BitSet irrelevantAccesses) {
            this.irrelevantAccesses = irrelevantAccesses;
        }

        @Override
        public boolean test(OwnedAndAccessedElements rel1, OwnedAndAccessedElements rel2) {
            if (rel1.ownedElements.intersects(rel2.accessedElements) || rel1.accessedElements.intersects(rel2.ownedElements)) {
                return true;
            }
            BitSet access1 = BitSets.copy((BitSet)rel1.accessedElements);
            access1.andNot(this.irrelevantAccesses);
            return access1.intersects(rel2.accessedElements);
        }
    }
}

