/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.checkers;

import java.util.Comparator;
import java.util.Objects;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CifCheckViolationContext
implements Comparable<CifCheckViolationContext> {
    private final boolean entireSpec;
    private final String typeDescription;
    private final String absName;

    public CifCheckViolationContext(boolean entireSpec, PositionObject contextObject) {
        Assert.implies((boolean)entireSpec, (contextObject == null ? 1 : 0) != 0);
        this.entireSpec = entireSpec;
        this.typeDescription = entireSpec ? null : (contextObject == null ? "the top-level scope of the specification" : CifTextUtils.getTypeDescriptionForNamedObject((PositionObject)contextObject));
        this.absName = entireSpec || contextObject == null ? null : CifTextUtils.getAbsName((PositionObject)contextObject);
    }

    public boolean isEntireSpec() {
        return this.entireSpec;
    }

    public String getTypeDescription() {
        return this.typeDescription;
    }

    public String getAbsName() {
        return this.absName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CifCheckViolationContext)) {
            return false;
        }
        CifCheckViolationContext that = (CifCheckViolationContext)obj;
        return this.entireSpec == that.entireSpec && Objects.equals(this.typeDescription, that.typeDescription) && Objects.equals(this.absName, that.absName);
    }

    public int hashCode() {
        return Objects.hash(this.entireSpec, this.typeDescription, this.absName);
    }

    @Override
    public int compareTo(CifCheckViolationContext other) {
        return Comparator.comparing(c -> !c.entireSpec).thenComparing(c -> c.absName != null).thenComparing(c -> c.absName).thenComparing(c -> c.typeDescription).compare(this, other);
    }

    public String toString() {
        if (this.entireSpec) {
            return "the specification";
        }
        return this.typeDescription + (String)(this.absName == null ? "" : " \"" + this.absName + "\"");
    }
}

