/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.codegen.java;

import java.util.List;
import java.util.Map;
import org.eclipse.escet.chi.codegen.java.JavaMethod;
import org.eclipse.escet.common.box.Boxable;
import org.eclipse.escet.common.box.VBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;

public abstract class JavaFile
implements Boxable {
    private final String fqClassname;
    protected Map<String, Boolean> imports;
    private List<JavaMethod> methods;

    public JavaFile(String packageName, String name) {
        this.fqClassname = packageName == null || packageName.isEmpty() ? name : packageName + "." + name;
        this.imports = Maps.map();
        this.methods = Lists.list();
    }

    public String getClassName() {
        int idx = this.fqClassname.lastIndexOf(46);
        if (idx == -1) {
            return this.fqClassname;
        }
        return this.fqClassname.substring(idx + 1);
    }

    public String getPackageName() {
        int idx = this.fqClassname.lastIndexOf(46);
        if (idx == -1) {
            return null;
        }
        return this.fqClassname.substring(0, idx);
    }

    public String getFQclassname() {
        return this.fqClassname;
    }

    public void addImport(String importName, boolean staticImport) {
        Boolean b = this.imports.get(importName);
        Assert.check((b == null || b == staticImport ? 1 : 0) != 0);
        if (b == null) {
            this.imports.put(importName, staticImport);
        }
    }

    public void addImports(List<String> imports) {
        for (String line : imports) {
            this.addImport(line, false);
        }
    }

    public void addMethod(JavaMethod method) {
        this.methods.add(method);
    }

    protected void boxifyPreamble(VBox box) {
        boolean addemptyLine = false;
        String packageName = this.getPackageName();
        if (packageName != null) {
            box.add("package " + packageName + ";");
            addemptyLine = true;
        }
        if (!this.imports.isEmpty()) {
            if (addemptyLine) {
                box.add("");
            }
            for (Map.Entry<String, Boolean> entry : this.imports.entrySet()) {
                Object s = "import";
                if (entry.getValue().booleanValue()) {
                    s = (String)s + " static";
                }
                box.add((String)s + " " + entry.getKey() + ";");
            }
            addemptyLine = true;
        }
        if (addemptyLine) {
            box.add("");
        }
        box.add("@SuppressWarnings(\"javadoc\")");
    }

    protected void boxifyStandardVariables(VBox box) {
        box.add("private static final boolean ALWAYS = true;");
        box.add("private static final boolean NEVER = false;");
    }

    protected void boxifyMethods(VBox box) {
        for (JavaMethod m : this.methods) {
            box.add(m.generateBox(), true);
        }
    }
}

