/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2mcrl2;

import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InvalidOptionException;
import org.eclipse.escet.common.java.output.WarnOutput;

public class ProcessValueActions {
    private static final Pattern FILTER_PATTERN = Pattern.compile("[-+]?[a-zA-Z_*][a-zA-Z0-9_*]*(\\.[a-zA-Z_*][a-zA-Z0-9_*]*)*");

    private ProcessValueActions() {
    }

    public static Set<String> matchNames(String optValue, Set<String> names, WarnOutput warn) {
        List<OptionPattern> patterns = ProcessValueActions.getValueActionsOptionPatterns(optValue);
        if (names.isEmpty()) {
            return names;
        }
        Set matchedNames = Sets.set();
        for (String name : names) {
            boolean added = false;
            for (OptionPattern pat : patterns) {
                boolean matchCausesChange;
                if (!pat.isMatch(name, matchCausesChange = added ^ pat.addMatch)) continue;
                added = pat.addMatch;
            }
            if (!added) continue;
            matchedNames.add(name);
        }
        for (OptionPattern pat : patterns) {
            if (!pat.wasMatched) {
                String msg = Strings.fmt((String)"Value actions pattern \"%s\" does not match any variable or automaton in the specification.", (Object[])new Object[]{pat.originalText});
                warn.line(msg);
                continue;
            }
            if (pat.causedChange) continue;
            String reason = pat.addMatch ? "Matched variables and automata were already added earlier." : "Matched variables and automata were never added or already removed earlier.";
            String msg = Strings.fmt((String)"Value actions pattern \"%s\" does not make any change to the selected variables or automata. %s", (Object[])new Object[]{pat.originalText, reason});
            warn.line(msg);
        }
        return matchedNames;
    }

    private static List<OptionPattern> getValueActionsOptionPatterns(String optValue) {
        List resultPatterns = Lists.list();
        String[] valuePatterns = StringUtils.split((String)optValue, (String)",");
        int i = 0;
        while (i < valuePatterns.length) {
            Object regex;
            boolean addMatch;
            String s = valuePatterns[i].trim();
            if (!FILTER_PATTERN.matcher(s).matches()) {
                String msg = Strings.fmt((String)"Value actions pattern \"%s\" has invalid syntax.", (Object[])new Object[]{s});
                throw new InvalidOptionException(msg);
            }
            if (s.charAt(0) == '+') {
                addMatch = true;
                regex = s.substring(1);
            } else if (s.charAt(0) == '-') {
                addMatch = false;
                regex = s.substring(1);
            } else {
                addMatch = true;
                regex = s;
            }
            regex = "^" + ((String)regex).replace(".", "\\.").replace("*", ".*") + "$";
            resultPatterns.add(new OptionPattern(addMatch, s, (String)regex));
            ++i;
        }
        return resultPatterns;
    }

    private static class OptionPattern {
        public final boolean addMatch;
        public final String originalText;
        public final Pattern pattern;
        public boolean wasMatched = false;
        public boolean causedChange = false;

        public OptionPattern(boolean addMatch, String originalText, String patternText) {
            this.addMatch = addMatch;
            this.originalText = originalText;
            this.pattern = Pattern.compile(patternText);
        }

        public boolean isMatch(String name, boolean makesChange) {
            boolean match = this.pattern.matcher(name).matches();
            if (match) {
                this.wasMatched = true;
                this.causedChange |= makesChange;
            }
            return match;
        }
    }
}

