/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.graph.text.serializer;

import com.google.inject.Inject;
import java.util.Map;
import org.eclipse.elk.graph.ElkGraphPackage;
import org.eclipse.elk.graph.impl.ElkPropertyToValueMapEntryImpl;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.IPropertyValueProxy;
import org.eclipse.elk.graph.text.serializer.AbstractElkGraphSemanticSequencer;
import org.eclipse.elk.graph.text.services.ElkGraphGrammarAccess;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.IDValueConverter;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;

public class ElkGraphSemanticSequencer
extends AbstractElkGraphSemanticSequencer {
    @Inject
    private ElkGraphGrammarAccess grammarAccess;
    private IDValueConverter idValueConverter;

    @Override
    protected void sequence_Property(ISerializationContext context, Map.Entry semanticObject) {
        if (semanticObject instanceof ElkPropertyToValueMapEntryImpl) {
            Object resolvedValue;
            IProperty key = ((ElkPropertyToValueMapEntryImpl)semanticObject).getKey();
            Object value = ((ElkPropertyToValueMapEntryImpl)semanticObject).getValue();
            if (value instanceof IPropertyValueProxy && key != null && (resolvedValue = ((IPropertyValueProxy)value).resolveValue(key)) != null) {
                ((ElkPropertyToValueMapEntryImpl)semanticObject).setValue(resolvedValue);
            }
            if (this.errorAcceptor != null && key == null) {
                this.errorAcceptor.accept(this.diagnosticProvider.createFeatureValueMissing((EObject)semanticObject, (EStructuralFeature)ElkGraphPackage.Literals.ELK_PROPERTY_TO_VALUE_MAP_ENTRY__KEY));
            }
            SequenceFeeder feeder = this.createSequencerFeeder(context, (EObject)semanticObject);
            feeder.accept(this.grammarAccess.getPropertyAccess().getKeyPropertyKeyParserRuleCall_0_0(), (Object)key);
            if (value instanceof Boolean) {
                feeder.accept(this.grammarAccess.getPropertyAccess().getValueBooleanValueParserRuleCall_2_3_0(), value);
            } else if (value instanceof Number) {
                feeder.accept(this.grammarAccess.getPropertyAccess().getValueNumberValueParserRuleCall_2_2_0(), value);
            } else if (value != null) {
                String string = value.toString();
                boolean _isQuotingNecessary = this.isQuotingNecessary(string);
                if (_isQuotingNecessary) {
                    feeder.accept(this.grammarAccess.getPropertyAccess().getValueStringValueParserRuleCall_2_0_0(), value);
                } else {
                    feeder.accept(this.grammarAccess.getPropertyAccess().getValueQualifiedIdValueParserRuleCall_2_1_0(), value);
                }
            }
            feeder.finish();
        } else {
            super.sequence_Property(context, semanticObject);
        }
    }

    private boolean isQuotingNecessary(String s) {
        try {
            Functions.Function1 _function = it -> this.idValueConverter.toString(it);
            return false;
        }
        catch (Throwable _t) {
            if (_t instanceof ValueConverterException) {
                return true;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }
}

