/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.graphviz.layouter;

import com.google.inject.Injector;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.elk.alg.graphviz.dot.GraphvizDotStandaloneSetup;
import org.eclipse.elk.alg.graphviz.dot.dot.GraphvizModel;
import org.eclipse.elk.alg.graphviz.dot.transform.Command;
import org.eclipse.elk.alg.graphviz.dot.transform.DotExporter;
import org.eclipse.elk.alg.graphviz.dot.transform.DotResourceSetProvider;
import org.eclipse.elk.alg.graphviz.dot.transform.DotTransformationData;
import org.eclipse.elk.alg.graphviz.dot.transform.IDotTransformationData;
import org.eclipse.elk.alg.graphviz.layouter.GraphvizException;
import org.eclipse.elk.alg.graphviz.layouter.GraphvizTool;
import org.eclipse.elk.alg.graphviz.layouter.LayoutDotExporter;
import org.eclipse.elk.alg.graphviz.layouter.preferences.GraphvizLayouterPreferenceStoreAccess;
import org.eclipse.elk.alg.graphviz.layouter.util.ForkedOutputStream;
import org.eclipse.elk.alg.graphviz.layouter.util.ForwardingInputStream;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.core.util.WrappedException;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;

public class GraphvizLayoutProvider
extends AbstractLayoutProvider {
    public static final String PREF_GRAPHVIZ_REUSE_PROCESS = "graphviz.reuseProcess";
    public static final boolean REUSE_PROCESS_DEFAULT = true;
    private static int serialCallNo = 0;
    private Command command = Command.INVALID;
    private GraphvizTool graphvizTool;
    private DotResourceSetProvider dotResourceSetProvider;
    private int myCallNo;
    private Injector injector;

    public void initialize(String parameter) {
        this.command = Command.valueOf((String)parameter);
        this.graphvizTool = new GraphvizTool(this.command);
        this.dotResourceSetProvider = (DotResourceSetProvider)this.getInjector().getInstance(DotResourceSetProvider.class);
    }

    public void dispose() {
        this.graphvizTool.cleanup(GraphvizTool.Cleanup.STOP);
    }

    private Injector getInjector() {
        if (this.injector == null) {
            this.injector = new GraphvizDotStandaloneSetup().createInjectorAndDoEMFRegistration();
        }
        return this.injector;
    }

    public void layout(ElkNode parentNode, IElkProgressMonitor progressMonitor) {
        if (this.command == Command.INVALID) {
            throw new IllegalStateException("The Graphviz layout provider is not initialized.");
        }
        progressMonitor.begin("Graphviz layout (" + String.valueOf(this.command) + ")", 2.0f);
        if (parentNode.getChildren().isEmpty()) {
            progressMonitor.done();
            return;
        }
        boolean debugMode = (Boolean)parentNode.getProperty(CoreOptions.DEBUG_MODE);
        this.myCallNo = ++serialCallNo;
        this.graphvizTool.initialize();
        XtextResourceSet resourceSet = (XtextResourceSet)this.dotResourceSetProvider.createResourceSet();
        LayoutDotExporter dotExporter = new LayoutDotExporter();
        DotTransformationData transData = new DotTransformationData();
        transData.setSourceGraph((Object)parentNode);
        transData.setProperty(DotExporter.COMMAND, (Object)this.command);
        dotExporter.transform((IDotTransformationData)transData);
        GraphvizModel graphvizInput = (GraphvizModel)transData.getTargetGraphs().get(0);
        this.writeDotGraph(graphvizInput, progressMonitor.subTask(1.0f), debugMode, resourceSet);
        try {
            GraphvizModel graphvizOutput = this.readDotGraph(progressMonitor.subTask(1.0f), debugMode, resourceSet);
            transData.getTargetGraphs().set(0, graphvizOutput);
            dotExporter.transferLayout((IDotTransformationData)transData);
        }
        catch (Throwable throwable) {
            boolean reuseProcess = false;
            if (Platform.isRunning()) {
                reuseProcess = GraphvizLayouterPreferenceStoreAccess.getUISaveBoolean(PREF_GRAPHVIZ_REUSE_PROCESS, true);
            }
            this.graphvizTool.cleanup(reuseProcess ? GraphvizTool.Cleanup.NORMAL : GraphvizTool.Cleanup.STOP);
            progressMonitor.done();
            throw throwable;
        }
        boolean reuseProcess = false;
        if (Platform.isRunning()) {
            reuseProcess = GraphvizLayouterPreferenceStoreAccess.getUISaveBoolean(PREF_GRAPHVIZ_REUSE_PROCESS, true);
        }
        this.graphvizTool.cleanup(reuseProcess ? GraphvizTool.Cleanup.NORMAL : GraphvizTool.Cleanup.STOP);
        progressMonitor.done();
    }

    private void writeDotGraph(GraphvizModel graphvizModel, IElkProgressMonitor monitor, boolean debugMode, XtextResourceSet resourceSet) {
        monitor.begin("Serialize model", 1.0f);
        OutputStream outputStream = this.graphvizTool.input();
        FileOutputStream debugStream = null;
        if (debugMode) {
            try {
                Object path = System.getProperty("user.home");
                path = ((String)path).endsWith(File.separator) ? (String)path + "tmp" + File.separator + "graphviz" : (String)path + File.separator + "tmp" + File.separator + "graphviz";
                new File((String)path).mkdirs();
                debugStream = new FileOutputStream(new File((String)path + File.separator + this.debugFileBase() + "-in.dot"));
                outputStream = new ForkedOutputStream(outputStream, debugStream);
            }
            catch (Exception exception) {
                System.out.println("GraphvizLayouter: Could not initialize debug output: " + exception.getMessage());
            }
        }
        try {
            try {
                XtextResource resource = (XtextResource)resourceSet.createResource(URI.createURI((String)"output.graphviz_dot"));
                resource.getContents().add((Object)graphvizModel);
                Map saveOptions = SaveOptions.newBuilder().noValidation().getOptions().toOptionsMap();
                resource.save(outputStream, saveOptions);
                outputStream.write(10);
                outputStream.flush();
            }
            catch (IOException exception) {
                this.graphvizTool.cleanup(GraphvizTool.Cleanup.ERROR);
                throw new WrappedException("Failed to send the graph to Graphviz.", (Throwable)exception);
            }
        }
        finally {
            if (debugStream != null) {
                try {
                    debugStream.close();
                }
                catch (IOException iOException) {}
            }
            monitor.done();
        }
    }

    private GraphvizModel readDotGraph(IElkProgressMonitor monitor, boolean debugMode, XtextResourceSet resourceSet) {
        monitor.begin("Parse output", 1.0f);
        InputStream inputStream = this.graphvizTool.output();
        FileOutputStream debugStream = null;
        if (debugMode) {
            try {
                Object path = System.getProperty("user.home");
                path = ((String)path).endsWith(File.separator) ? (String)path + "tmp" + File.separator + "graphviz" : (String)path + File.separator + "tmp" + File.separator + "graphviz";
                new File((String)path).mkdirs();
                debugStream = new FileOutputStream(new File((String)path + File.separator + this.debugFileBase() + "-out.dot"));
                inputStream = new ForwardingInputStream(inputStream, debugStream);
            }
            catch (Exception exception) {
                System.out.println("GraphvizLayouter: Could not initialize debug output: " + exception.getMessage());
            }
        }
        XtextResource resource = (XtextResource)resourceSet.createResource(URI.createURI((String)"input.graphviz_dot"));
        try {
            try {
                resource.load(inputStream, null);
            }
            catch (IOException exception) {
                this.graphvizTool.cleanup(GraphvizTool.Cleanup.ERROR);
                throw new WrappedException("Failed to read Graphviz output.", (Throwable)exception);
            }
        }
        finally {
            if (debugStream != null) {
                try {
                    debugStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (!resource.getErrors().isEmpty()) {
            StringBuilder errorString = new StringBuilder("Errors in Graphviz output:");
            for (Resource.Diagnostic diagnostic : resource.getErrors()) {
                errorString.append("\n" + diagnostic.getLine() + ": " + diagnostic.getMessage());
            }
            this.graphvizTool.cleanup(GraphvizTool.Cleanup.ERROR);
            throw new GraphvizException(errorString.toString());
        }
        GraphvizModel graphvizModel = (GraphvizModel)resource.getParseResult().getRootASTElement();
        if (graphvizModel == null || graphvizModel.getGraphs().isEmpty()) {
            this.graphvizTool.cleanup(GraphvizTool.Cleanup.ERROR);
            throw new GraphvizException("No output from the Graphviz process. Try increasing the timeout value in the Eclipse Diagram Layout preferences.");
        }
        monitor.done();
        return graphvizModel;
    }

    private String debugFileBase() {
        String no = Integer.toString(this.myCallNo);
        switch (no.length()) {
            case 1: {
                return "debug00" + no;
            }
            case 2: {
                return "debug0" + no;
            }
        }
        return "debug" + no;
    }
}

