/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.util;

import java.io.File;
import java.io.FileFilter;
import java.util.StringTokenizer;

public final class FilterUtil
implements FileFilter {
    private String filterString = null;
    private String extPattern = null;
    private String namePattern = null;

    public FilterUtil() {
    }

    public FilterUtil(String filterStr) {
        if (filterStr != null) {
            this.filterString = filterStr;
            this.filterString = filterStr.trim();
            int index = this.filterString.indexOf(46);
            if (index == -1) {
                this.namePattern = this.filterString;
            } else if (index == 0) {
                if (this.filterString.length() > 1) {
                    this.extPattern = this.filterString.substring(1);
                }
            } else if (index == this.filterString.length() - 1) {
                this.namePattern = this.filterString.substring(0, index - 1);
            } else {
                this.namePattern = this.filterString.substring(0, index);
                this.extPattern = this.filterString.substring(index + 1);
            }
        }
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory() || this.filterString == null || this.filterString.length() == 0 || this.filterString.equals("*")) {
            return true;
        }
        String fileName = f.getName();
        if (this.filterString.equals(fileName)) {
            return true;
        }
        String extension = FilterUtil.getExtension(fileName);
        String name = FilterUtil.getName(fileName);
        if (this.filterString.indexOf(46) == -1) {
            return FilterUtil.check(fileName, this.filterString);
        }
        if (this.filterString.indexOf(46) != -1 && fileName.indexOf(46) == -1) {
            return false;
        }
        boolean nameFlag = FilterUtil.check(name, this.namePattern);
        boolean extFlag = FilterUtil.check(extension, this.extPattern);
        return nameFlag && extFlag;
    }

    private static boolean check(String value, String pattern) {
        boolean flag = false;
        if (value == null && pattern == null) {
            flag = true;
        } else if (value == null && pattern != null) {
            if (pattern.equals("*")) {
                flag = true;
            }
        } else if (value != null && pattern != null) {
            if (pattern.equals("*")) {
                flag = true;
            } else if (pattern.equals(value)) {
                flag = true;
            } else {
                StringTokenizer st = new StringTokenizer(pattern, "*");
                if (st.countTokens() == 1) {
                    if (pattern.endsWith("*") && pattern.startsWith("*")) {
                        flag = FilterUtil.checkPattern(st, value);
                    } else if (pattern.endsWith("*")) {
                        String prefix = pattern.substring(0, pattern.length() - 1);
                        flag = value.startsWith(prefix);
                    } else if (pattern.startsWith("*")) {
                        String suffix = pattern.substring(1, pattern.length());
                        flag = value.endsWith(suffix);
                    }
                } else {
                    flag = FilterUtil.checkPattern(st, value);
                }
            }
        }
        return flag;
    }

    private static boolean checkPattern(StringTokenizer token, String name) {
        int position = 0;
        boolean flag = true;
        while (token.hasMoreTokens()) {
            String subset = token.nextToken();
            int index = name.indexOf(subset, position);
            if (index == -1) {
                flag = false;
                break;
            }
            position = index + subset.length();
        }
        return flag;
    }

    private static String getExtension(String name) {
        String ext = null;
        if (name != null) {
            int i = name.indexOf(46);
            if (i == -1) {
                return null;
            }
            if (i == 0) {
                ext = name.substring(1);
            } else if (i < name.length() - 1) {
                ext = name.substring(i + 1);
            }
        }
        return ext;
    }

    private static String getName(String name) {
        if (name == null) {
            return null;
        }
        String fileName = null;
        int length = name.length();
        int i = name.indexOf(46);
        if (i == -1) {
            fileName = name;
        } else if (i == 0) {
            fileName = null;
        } else if (i <= length - 1) {
            fileName = name.substring(0, i);
        }
        return fileName;
    }
}

