/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.web.cache;

import com.sun.appserv.util.cache.Cache;
import com.sun.appserv.web.cache.CacheHelper;
import com.sun.appserv.web.cache.CacheManagerListener;
import com.sun.appserv.web.cache.DefaultCacheHelper;
import com.sun.appserv.web.cache.mapping.CacheMapping;
import jakarta.servlet.ServletContext;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.LifecycleException;
import org.glassfish.web.LogFacade;

public class CacheManager {
    public static final String CACHE_MANAGER_ATTR_NAME = "com.sun.appserv.web.CacheManager";
    public static final int DEFAULT_CACHE_MAX_ENTRIES = 4096;
    public static final int DEFAULT_CACHE_TIMEOUT = 30;
    public static final String DEFAULT_CACHE_CLASSNAME = "com.sun.appserv.util.cache.LruCache";
    private static final Logger _logger = LogFacade.getLogger();
    private static final ResourceBundle _rb = _logger.getResourceBundle();
    int maxEntries = 4096;
    int defaultTimeout = 30;
    String cacheClassName = "com.sun.appserv.util.cache.LruCache";
    boolean enabled = false;
    ServletContext context;
    Properties cacheProps;
    Cache defaultCache;
    HashMap<String, CacheMapping> cacheMappings = new HashMap();
    Map<String, String> defaultHelperProps;
    DefaultCacheHelper defaultHelper;
    HashMap<String, HashMap<String, String>> helperDefs = new HashMap();
    HashMap<String, CacheHelper> cacheHelpers = new HashMap();
    HashMap<String, CacheHelper> cacheHelpersByFilterName = new HashMap();
    ArrayList<CacheManagerListener> listeners = new ArrayList();

    public void setMaxEntries(int maxEntries) {
        this.maxEntries = maxEntries;
    }

    public void setDefaultTimeout(int defaultTimeout) {
        this.defaultTimeout = defaultTimeout;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void addProperty(String name, String value) {
        if (name.equalsIgnoreCase("cacheClassName")) {
            this.cacheClassName = value;
        } else {
            if (this.cacheProps == null) {
                this.cacheProps = new Properties();
            }
            this.cacheProps.setProperty(name, value);
        }
    }

    public void addCacheHelperDef(String name, HashMap<String, String> helperDef) {
        this.helperDefs.put(name, helperDef);
    }

    public void setDefaultHelperProps(Map<String, String> map) {
        this.defaultHelperProps = map;
    }

    public void setServletContext(ServletContext context) {
        this.context = context;
    }

    private CacheHelper loadCacheHelper(String className) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class<?> helperClass = cl.loadClass(className);
        CacheHelper helper = (CacheHelper)helperClass.newInstance();
        return helper;
    }

    public void start() throws LifecycleException {
        if (!this.enabled) {
            return;
        }
        try {
            this.defaultCache = this.createCache(this.maxEntries, this.cacheClassName);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "AS-WEB-GLUE-00001", e);
            throw new LifecycleException(_rb.getString("AS-WEB-GLUE-00001"), (Throwable)e);
        }
        this.defaultHelper = new DefaultCacheHelper();
        this.defaultHelper.setCacheManager(this);
        this.defaultHelper.init(this.context, this.defaultHelperProps);
        for (String name : this.helperDefs.keySet()) {
            HashMap<String, String> map = this.helperDefs.get(name);
            try {
                String className = map.get("class-name");
                CacheHelper helper = this.loadCacheHelper(className);
                helper.init(this.context, map);
                this.cacheHelpers.put(name, helper);
            }
            catch (Exception e) {
                String msg = _rb.getString("AS-WEB-GLUE-00002");
                Object[] params = new Object[]{name};
                msg = MessageFormat.format(msg, params);
                throw new LifecycleException(msg, (Throwable)e);
            }
        }
        for (String name : this.cacheMappings.keySet()) {
            CacheMapping mapping = this.cacheMappings.get(name);
            String helperNameRef = mapping.getHelperNameRef();
            CacheHelper helper = helperNameRef == null || helperNameRef.equals("default") ? this.defaultHelper : this.cacheHelpers.get(helperNameRef);
            this.cacheHelpersByFilterName.put(name, helper);
        }
    }

    public String getCacheClassName() {
        return this.cacheClassName;
    }

    public Cache createCache() throws Exception {
        return this.createCache(this.maxEntries, DEFAULT_CACHE_CLASSNAME);
    }

    public Cache createCache(int cacacity, String className) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class<?> cacheClass = cl.loadClass(className);
        Cache cacheImpl = (Cache)cacheClass.newInstance();
        cacheImpl.init(this.maxEntries, this.cacheProps);
        return cacheImpl;
    }

    public int getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public Cache getDefaultCache() {
        return this.defaultCache;
    }

    public void addCacheMapping(String name, CacheMapping mapping) {
        this.cacheMappings.put(name, mapping);
    }

    public CacheMapping getCacheMapping(String name) {
        return this.cacheMappings.get(name);
    }

    public CacheHelper getCacheHelper(String name) {
        return this.cacheHelpers.get(name);
    }

    public CacheHelper getCacheHelperByFilterName(String filterName) {
        return this.cacheHelpersByFilterName.get(filterName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCacheManagerListener(CacheManagerListener listener) {
        ArrayList<CacheManagerListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCacheManagerListener(CacheManagerListener listener) {
        ArrayList<CacheManagerListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
        }
    }

    public void enable() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            CacheManagerListener listener = this.listeners.get(i);
            listener.cacheManagerEnabled();
        }
    }

    public void disable() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            CacheManagerListener listener = this.listeners.get(i);
            listener.cacheManagerDisabled();
        }
    }

    public void stop() throws LifecycleException {
        this.disable();
        try {
            if (this.defaultHelper != null) {
                this.defaultHelper.destroy();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Enumeration<CacheHelper> helpers = Collections.enumeration(this.cacheHelpers.values());
        while (helpers.hasMoreElements()) {
            CacheHelper cacheHelper = helpers.nextElement();
            try {
                cacheHelper.destroy();
            }
            catch (Exception exception) {}
        }
        this.cacheHelpers.clear();
        this.cacheMappings.clear();
        this.cacheHelpersByFilterName.clear();
        this.listeners.clear();
    }
}

