/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cdi.transaction;

import com.sun.enterprise.transaction.TransactionManagerHelper;
import jakarta.annotation.Priority;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import jakarta.transaction.SystemException;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.Transactional;
import jakarta.transaction.TransactionalException;
import org.glassfish.cdi.transaction.TransactionalInterceptorBase;

@Priority(value=200)
@Interceptor
@Transactional(value=Transactional.TxType.REQUIRED)
public class TransactionalInterceptorRequired
extends TransactionalInterceptorBase {
    private static final long serialVersionUID = 7783065031210674657L;
    private static final System.Logger LOG = System.getLogger(TransactionalInterceptorRequired.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object transactional(InvocationContext ctx) throws Exception {
        LOG.log(System.Logger.Level.TRACE, "Processing transactional context of type: {0}", Transactional.TxType.REQUIRED);
        if (this.isLifeCycleMethod(ctx)) {
            return this.proceed(ctx);
        }
        this.setTransactionalTransactionOperationsManger(false);
        try {
            boolean isTransactionStarted = this.beginTransaction();
            try {
                Object object = this.proceed(ctx);
                if (isTransactionStarted) {
                    this.finishTransaction();
                }
                return object;
            }
            catch (Throwable throwable) {
                if (isTransactionStarted) {
                    this.finishTransaction();
                }
                throw throwable;
            }
        }
        finally {
            this.resetTransactionOperationsManager();
        }
    }

    private boolean beginTransaction() throws SystemException {
        if (this.getTransactionManager().getTransaction() != null) {
            return false;
        }
        LOG.log(System.Logger.Level.DEBUG, "Managed bean with Transactional annotation and TxType of REQUIRED called outside a transaction context. Beginning a transaction...");
        try {
            this.getTransactionManager().begin();
            TransactionManager tm = this.getTransactionManager();
            if (tm instanceof TransactionManagerHelper) {
                ((TransactionManagerHelper)tm).preInvokeTx(true);
            }
            return true;
        }
        catch (Exception e) {
            throw new TransactionalException("Managed bean with Transactional annotation and TxType of REQUIRED encountered exception during begin: " + e.getMessage(), (Throwable)e);
        }
    }

    private void finishTransaction() {
        try {
            if (this.getTransactionManager() instanceof TransactionManagerHelper) {
                ((TransactionManagerHelper)this.getTransactionManager()).postInvokeTx(false, true);
            }
            if (this.getTransactionManager().getTransaction().getStatus() == 1) {
                this.getTransactionManager().rollback();
            } else {
                this.getTransactionManager().commit();
            }
        }
        catch (Exception e) {
            throw new TransactionalException("Managed bean with Transactional annotation and TxType of REQUIRED encountered exception during commit/rollback: " + e.getMessage(), (Throwable)e);
        }
    }
}

