/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.microprofile.health;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.glassfish.microprofile.health.GlassFishHealthCheckResponse;

public class GlassFishHealthCheckResponseBuilder
extends HealthCheckResponseBuilder {
    private final Map<String, Object> data = new HashMap<String, Object>();
    private String name;
    private HealthCheckResponse.Status status;

    public HealthCheckResponseBuilder name(String name) {
        this.name = name;
        return this;
    }

    public HealthCheckResponseBuilder withData(String key, String value) {
        this.data.put(key, value);
        return this;
    }

    public HealthCheckResponseBuilder withData(String key, long value) {
        this.data.put(key, value);
        return this;
    }

    public HealthCheckResponseBuilder withData(String key, boolean value) {
        this.data.put(key, value);
        return this;
    }

    public HealthCheckResponseBuilder up() {
        return this.status(true);
    }

    public HealthCheckResponseBuilder down() {
        return this.status(false);
    }

    public HealthCheckResponseBuilder status(boolean up) {
        this.status = up ? HealthCheckResponse.Status.UP : HealthCheckResponse.Status.DOWN;
        return this;
    }

    public HealthCheckResponse build() {
        return new GlassFishHealthCheckResponse(this.name, this.status, this.data.isEmpty() ? Optional.empty() : Optional.of(this.data));
    }
}

