/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.nio.ByteBuffer;

public class ClusterTransferFileEndInfo {
    private GPacket pkt = null;
    private String uuid = null;
    private String module = null;
    private String brokerID = null;
    private String filename = null;
    private byte[] digest = null;
    private boolean moreFiles = false;

    private ClusterTransferFileEndInfo(String uuid, String module, String brokerID, String filename, byte[] digest, boolean morefiles) {
        this.uuid = uuid;
        this.brokerID = brokerID;
        this.module = module;
        this.filename = filename;
        this.digest = digest;
        this.moreFiles = morefiles;
    }

    private ClusterTransferFileEndInfo(GPacket pkt) {
        assert (pkt.getType() == 69);
        this.pkt = pkt;
    }

    public static ClusterTransferFileEndInfo newInstance(String uuid, String module, String brokerID, String filename, byte[] digest, boolean morefiles) {
        return new ClusterTransferFileEndInfo(uuid, module, brokerID, filename, digest, morefiles);
    }

    public static ClusterTransferFileEndInfo newInstance(GPacket pkt) {
        return new ClusterTransferFileEndInfo(pkt);
    }

    public GPacket getGPacket() throws BrokerException {
        if (this.pkt != null) {
            return this.pkt;
        }
        GPacket gp = GPacket.getInstance();
        gp.putProp((Object)"uuid", (Object)this.uuid);
        gp.putProp((Object)"module", (Object)this.module);
        gp.putProp((Object)"brokerID", (Object)this.brokerID);
        gp.putProp((Object)"filename", (Object)this.filename);
        gp.putProp((Object)"morefiles", (Object)this.moreFiles);
        gp.setType((short)69);
        gp.setPayload(ByteBuffer.wrap(this.digest));
        gp.setBit(1, true);
        return gp;
    }

    public String getUUID() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp((Object)"uuid");
    }

    public String getModule() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp((Object)"module");
    }

    public String getBrokerID() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp((Object)"brokerID");
    }

    public String getFileName() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp((Object)"filename");
    }

    public boolean hasMoreFiles() {
        assert (this.pkt != null);
        return (Boolean)this.pkt.getProp((Object)"morefiles");
    }

    public byte[] getDigest() {
        assert (this.pkt != null);
        byte[] buf = null;
        if (this.pkt.getPayload() != null) {
            buf = this.pkt.getPayload().array();
        }
        return buf;
    }

    public static GPacket getReplyGPacket(int status, String reason) {
        GPacket gp = GPacket.getInstance();
        gp.setType((short)70);
        gp.putProp((Object)"S", (Object)status);
        if (reason != null) {
            gp.putProp((Object)"reason", (Object)reason);
        }
        return gp;
    }

    public static GPacket getReplyAckGPacket(int status, String reason) {
        GPacket gp = GPacket.getInstance();
        gp.setType((short)71);
        gp.putProp((Object)"S", (Object)status);
        if (reason != null) {
            gp.putProp((Object)"reason", (Object)reason);
        }
        return gp;
    }

    public static int getReplyStatus(GPacket gp) {
        return (Integer)gp.getProp((Object)"S");
    }

    public static String getReplyStatusReason(GPacket gp) {
        return (String)gp.getProp((Object)"reason");
    }

    public String toString() {
        if (this.pkt != null) {
            return "[brokerID=" + this.getBrokerID() + ", file=" + this.getFileName() + "]" + this.getUUID() + "(" + this.hasMoreFiles() + ")";
        }
        return "[brokerID=" + this.brokerID + ", file=" + this.filename + "]" + this.uuid + "(" + this.moreFiles + ")";
    }
}

