/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap.launch;

import com.sun.enterprise.glassfish.bootstrap.launch.Launcher;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import org.glassfish.main.jdke.cl.GlassfishUrlClassLoader;

public class GlassfishOsgiBootstrapClassLoader
extends GlassfishUrlClassLoader {
    public GlassfishOsgiBootstrapClassLoader(File glassfishDir, ClassLoader parent) throws IOException {
        super("GlassFishOsgiBootstrap", GlassfishOsgiBootstrapClassLoader.createUrls(glassfishDir), parent);
    }

    public void launchGlassFishServer(Properties properties) {
        try {
            Class launcherClass = this.loadClass("org.glassfish.main.boot.osgi.GlassFishOsgiLauncher");
            Launcher launcher = (Launcher)launcherClass.getDeclaredConstructor(ClassLoader.class).newInstance(new Object[]{this});
            launcher.launch(properties);
        }
        catch (Exception e) {
            throw new Error("Failed to launch GlassFish Server!", e);
        }
    }

    private static URL[] createUrls(File glassfishDir) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        File moduleDir = new File(glassfishDir, "modules");
        urls.add(GlassfishOsgiBootstrapClassLoader.getURL(moduleDir, "glassfish-osgi-bootstrap"));
        return (URL[])urls.toArray(URL[]::new);
    }

    private static URL getURL(File dir, String jarFileName) throws IOException {
        File file = new File(dir, jarFileName + ".jar");
        try {
            if (!file.canRead()) {
                throw new IOException("The jar file does not exist or cannot be read: " + String.valueOf(file));
            }
            return new File(dir, jarFileName + ".jar").toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IOException("Could not convert file " + String.valueOf(file) + " to url.", e);
        }
    }

    static {
        GlassfishOsgiBootstrapClassLoader.registerAsParallelCapable();
    }
}

