/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.runlevel;

import java.lang.annotation.Annotation;
import org.glassfish.hk2.api.AnnotationLiteral;
import org.glassfish.hk2.api.DuplicateServiceException;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.hk2.runlevel.RunLevelContext;
import org.glassfish.hk2.runlevel.internal.AsyncRunLevelContext;
import org.glassfish.hk2.runlevel.internal.RunLevelControllerImpl;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;

public class RunLevelServiceUtilities {
    public static void enableRunLevelService(ServiceLocator locator) {
        block3: {
            if (locator.getService(RunLevelContext.class, new Annotation[0]) != null) {
                return;
            }
            try {
                ServiceLocatorUtilities.addClasses((ServiceLocator)locator, (boolean)true, (Class[])new Class[]{RunLevelContext.class, AsyncRunLevelContext.class, RunLevelControllerImpl.class});
            }
            catch (MultiException me) {
                if (RunLevelServiceUtilities.isDupException(me)) break block3;
                throw me;
            }
        }
    }

    private static boolean isDupException(MultiException me) {
        boolean atLeastOne = false;
        for (Throwable error : me.getErrors()) {
            atLeastOne = true;
            if (error instanceof DuplicateServiceException) continue;
            return false;
        }
        return atLeastOne;
    }

    public static RunLevel getRunLevelAnnotation(int value) {
        return RunLevelServiceUtilities.getRunLevelAnnotation(value, 1);
    }

    public static RunLevel getRunLevelAnnotation(int value, int mode) {
        return new RunLevelImpl(value, mode);
    }

    private static class RunLevelImpl
    extends AnnotationLiteral<RunLevel>
    implements RunLevel {
        private static final long serialVersionUID = -359213687920354669L;
        private final int value;
        private final int mode;

        private RunLevelImpl(int value, int mode) {
            this.value = value;
            this.mode = mode;
        }

        @Override
        public int value() {
            return this.value;
        }

        @Override
        public int mode() {
            return this.mode;
        }
    }
}

