/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.oracle.webservices.oracle_internal_api.rm.OutboundDelivered;
import com.sun.istack.logging.Logger;
import com.sun.xml.ws.rx.rm.protocol.AcknowledgementData;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;

class OutboundDeliveredHandler {
    private static final Logger LOGGER = Logger.getLogger(OutboundDeliveredHandler.class);
    private ConcurrentHashMap<MessageInfo, OutboundDelivered> map = new ConcurrentHashMap();

    OutboundDeliveredHandler() {
    }

    void store(String sequenceId, long messageNumber, OutboundDelivered outboundDelivered) {
        MessageInfo messageInfo = new MessageInfo(sequenceId, messageNumber);
        this.map.put(messageInfo, outboundDelivered);
    }

    OutboundDelivered retrieve(String sequenceId, long messageNumber) {
        MessageInfo messageInfo = new MessageInfo(sequenceId, messageNumber);
        return this.map.get(messageInfo);
    }

    void remove(String sequenceId, long messageNumber) {
        MessageInfo messageInfo = new MessageInfo(sequenceId, messageNumber);
        this.map.remove(messageInfo);
    }

    void processAcknowledgements(AcknowledgementData acknowledgementData) {
        String seqId = acknowledgementData.getAcknowledgedSequenceId();
        List<Sequence.AckRange> listOfAckRange = acknowledgementData.getAcknowledgedRanges();
        for (Sequence.AckRange ackRange : listOfAckRange) {
            List<Long> messageNumbers = ackRange.rangeValues();
            for (long messageNumber : messageNumbers) {
                OutboundDelivered outboundDelivered = this.retrieve(seqId, messageNumber);
                if (outboundDelivered == null) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Invoking outboundDelivered.setDelivered(true) for seq id:" + seqId + " and message number:" + messageNumber);
                }
                outboundDelivered.setDelivered(Boolean.TRUE);
                this.remove(seqId, messageNumber);
            }
        }
    }

    private static class MessageInfo {
        private final String sequenceId;
        private final long messageNumber;

        private MessageInfo(String seqId, long msgNumber) {
            this.sequenceId = seqId;
            this.messageNumber = msgNumber;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.messageNumber ^ this.messageNumber >>> 32);
            result = 31 * result + (this.sequenceId == null ? 0 : this.sequenceId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MessageInfo other = (MessageInfo)obj;
            if (this.messageNumber != other.messageNumber) {
                return false;
            }
            if (this.sequenceId == null) {
                return other.sequenceId == null;
            }
            return this.sequenceId.equals(other.sequenceId);
        }
    }
}

