/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.helpgenerator;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.ease.helpgenerator.IMemento;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class XMLMemento
implements IMemento {
    private final Document factory;
    private final Element element;

    public static XMLMemento createReadRoot(Reader reader) throws Exception {
        return XMLMemento.createReadRoot(reader, null);
    }

    public static XMLMemento createReadRoot(Reader reader, String baseDir) throws Exception {
        String errorMessage = null;
        Exception exception = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            InputSource source = new InputSource(reader);
            if (baseDir != null) {
                source.setSystemId(baseDir);
            }
            parser.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                }

                @Override
                public void error(SAXParseException exception) throws SAXException {
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    throw exception;
                }
            });
            Document document = parser.parse(source);
            NodeList list = document.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                if (!(node instanceof Element)) continue;
                return new XMLMemento(document, (Element)node);
            }
        }
        catch (ParserConfigurationException e) {
            exception = e;
            errorMessage = "WorkbenchMessages.XMLMemento_parserConfigError";
        }
        catch (IOException e) {
            exception = e;
            errorMessage = "WorkbenchMessages.XMLMemento_ioError";
        }
        catch (SAXException e) {
            exception = e;
            errorMessage = "WorkbenchMessages.XMLMemento_formatError";
        }
        String problemText = null;
        if (exception != null) {
            problemText = exception.getMessage();
        }
        if (problemText == null || problemText.length() == 0) {
            problemText = errorMessage != null ? errorMessage : "WorkbenchMessages.XMLMemento_noElement";
        }
        throw new Exception(problemText, exception);
    }

    public static XMLMemento createWriteRoot(String type) throws DOMException {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element element = document.createElement(type);
            document.appendChild(element);
            return new XMLMemento(document, element);
        }
        catch (ParserConfigurationException e) {
            throw new Error(e.getMessage());
        }
    }

    public XMLMemento(Document document, Element element) {
        this.factory = document;
        this.element = element;
    }

    @Override
    public IMemento createChild(String type) throws DOMException {
        Element child = this.factory.createElement(type);
        this.element.appendChild(child);
        return new XMLMemento(this.factory, child);
    }

    @Override
    public IMemento createChild(String type, String id) throws DOMException {
        Element child = this.factory.createElement(type);
        child.setAttribute("IMemento.internal.id", id == null ? "" : id);
        this.element.appendChild(child);
        return new XMLMemento(this.factory, child);
    }

    public IMemento copyChild(IMemento child) throws DOMException {
        Element childElement = ((XMLMemento)child).element;
        Element newElement = (Element)this.factory.importNode(childElement, true);
        this.element.appendChild(newElement);
        return new XMLMemento(this.factory, newElement);
    }

    @Override
    public IMemento getChild(String type) {
        NodeList nodes = this.element.getChildNodes();
        int size = nodes.getLength();
        if (size == 0) {
            return null;
        }
        for (int nX = 0; nX < size; ++nX) {
            Element element;
            Node node = nodes.item(nX);
            if (!(node instanceof Element) || !(element = (Element)node).getNodeName().equals(type)) continue;
            return new XMLMemento(this.factory, element);
        }
        return null;
    }

    @Override
    public IMemento[] getChildren() {
        NodeList nodes = this.element.getChildNodes();
        int size = nodes.getLength();
        if (size == 0) {
            return new IMemento[0];
        }
        ArrayList<Node> list = new ArrayList<Node>(size);
        for (int nX = 0; nX < size; ++nX) {
            Node node = nodes.item(nX);
            if (!(node instanceof Element)) continue;
            list.add(node);
        }
        size = list.size();
        IMemento[] results = new IMemento[size];
        for (int x = 0; x < size; ++x) {
            results[x] = new XMLMemento(this.factory, (Element)list.get(x));
        }
        return results;
    }

    @Override
    public IMemento[] getChildren(String type) {
        NodeList nodes = this.element.getChildNodes();
        int size = nodes.getLength();
        if (size == 0) {
            return new IMemento[0];
        }
        ArrayList<Element> list = new ArrayList<Element>(size);
        for (int nX = 0; nX < size; ++nX) {
            Element element;
            Node node = nodes.item(nX);
            if (!(node instanceof Element) || !(element = (Element)node).getNodeName().equals(type)) continue;
            list.add(element);
        }
        size = list.size();
        IMemento[] results = new IMemento[size];
        for (int x = 0; x < size; ++x) {
            results[x] = new XMLMemento(this.factory, (Element)list.get(x));
        }
        return results;
    }

    @Override
    public Float getFloat(String key) {
        Attr attr = this.element.getAttributeNode(key);
        if (attr == null) {
            return null;
        }
        String strValue = attr.getValue();
        try {
            return new Float(strValue);
        }
        catch (NumberFormatException e) {
            XMLMemento.log("Memento problem - Invalid float for key: " + key + " value: " + strValue, e);
            return null;
        }
    }

    @Override
    public String getType() {
        return this.element.getNodeName();
    }

    @Override
    public String getID() {
        return this.element.getAttribute("IMemento.internal.id");
    }

    @Override
    public Integer getInteger(String key) {
        Attr attr = this.element.getAttributeNode(key);
        if (attr == null) {
            return null;
        }
        String strValue = attr.getValue();
        try {
            return new Integer(strValue);
        }
        catch (NumberFormatException e) {
            XMLMemento.log("Memento problem - invalid integer for key: " + key + " value: " + strValue, e);
            return null;
        }
    }

    private static void log(String message, Exception e) {
        System.err.println(message);
        e.printStackTrace(System.err);
    }

    @Override
    public String getString(String key) {
        Attr attr = this.element.getAttributeNode(key);
        if (attr == null) {
            return null;
        }
        return attr.getValue();
    }

    @Override
    public Boolean getBoolean(String key) {
        Attr attr = this.element.getAttributeNode(key);
        if (attr == null) {
            return null;
        }
        return Boolean.valueOf(attr.getValue());
    }

    @Override
    public String getTextData() throws DOMException {
        Text textNode = this.getTextNode();
        if (textNode != null) {
            return textNode.getData();
        }
        return null;
    }

    @Override
    public String[] getAttributeKeys() {
        NamedNodeMap map = this.element.getAttributes();
        int size = map.getLength();
        String[] attributes = new String[size];
        for (int i = 0; i < size; ++i) {
            Node node = map.item(i);
            attributes[i] = node.getNodeName();
        }
        return attributes;
    }

    private Text getTextNode() {
        NodeList nodes = this.element.getChildNodes();
        int size = nodes.getLength();
        if (size == 0) {
            return null;
        }
        for (int nX = 0; nX < size; ++nX) {
            Node node = nodes.item(nX);
            if (!(node instanceof Text)) continue;
            return (Text)node;
        }
        return null;
    }

    private void putElement(Element element, boolean copyText) throws DOMException {
        NamedNodeMap nodeMap = element.getAttributes();
        int size = nodeMap.getLength();
        for (int i = 0; i < size; ++i) {
            Attr attr = (Attr)nodeMap.item(i);
            this.putString(attr.getName(), attr.getValue());
        }
        NodeList nodes = element.getChildNodes();
        size = nodes.getLength();
        boolean needToCopyText = copyText;
        for (int i = 0; i < size; ++i) {
            Node node = nodes.item(i);
            if (node instanceof Element) {
                XMLMemento child = (XMLMemento)this.createChild(node.getNodeName());
                child.putElement((Element)node, true);
                continue;
            }
            if (!(node instanceof Text) || !needToCopyText) continue;
            this.putTextData(((Text)node).getData());
            needToCopyText = false;
        }
    }

    @Override
    public void putFloat(String key, float f) throws DOMException {
        this.element.setAttribute(key, String.valueOf(f));
    }

    @Override
    public void putInteger(String key, int n) throws DOMException {
        this.element.setAttribute(key, String.valueOf(n));
    }

    @Override
    public void putMemento(IMemento memento) throws DOMException {
        this.putElement(((XMLMemento)memento).element, false);
    }

    @Override
    public void putString(String key, String value) throws DOMException {
        if (value == null) {
            return;
        }
        this.element.setAttribute(key, value);
    }

    @Override
    public void putBoolean(String key, boolean value) throws DOMException {
        this.element.setAttribute(key, value ? "true" : "false");
    }

    @Override
    public void putTextData(String data) throws DOMException {
        Text textNode = this.getTextNode();
        if (textNode == null) {
            textNode = this.factory.createTextNode(data);
            this.element.insertBefore(textNode, this.element.getFirstChild());
        } else {
            textNode.setData(data);
        }
    }

    public void save(Writer writer) throws IOException {
        try (DOMWriter out = new DOMWriter(writer);){
            out.print(this.element);
        }
    }

    public String toString() {
        try {
            StringWriter writer = new StringWriter();
            this.save(writer);
            return writer.toString();
        }
        catch (IOException e) {
            return super.toString();
        }
    }

    private static final class DOMWriter
    extends PrintWriter {
        private static final String XML_VERSION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";

        public DOMWriter(Writer output) {
            super(output);
            this.println(XML_VERSION);
        }

        public void print(Element element) {
            boolean hasChildren = element.hasChildNodes();
            this.startTag(element, hasChildren);
            if (hasChildren) {
                boolean prevWasText = false;
                NodeList children = element.getChildNodes();
                for (int i = 0; i < children.getLength(); ++i) {
                    Node node = children.item(i);
                    if (node instanceof Element) {
                        if (!prevWasText) {
                            this.println();
                        }
                        this.print((Element)children.item(i));
                        prevWasText = false;
                        continue;
                    }
                    if (!(node instanceof Text)) continue;
                    this.print(DOMWriter.getEscaped(node.getNodeValue()));
                    prevWasText = true;
                }
                if (!prevWasText) {
                    this.println();
                }
                this.endTag(element);
            }
        }

        private void startTag(Element element, boolean hasChildren) {
            StringBuffer sb = new StringBuffer();
            sb.append("<");
            sb.append(element.getTagName());
            NamedNodeMap attributes = element.getAttributes();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Attr attribute = (Attr)attributes.item(i);
                sb.append(" ");
                sb.append(attribute.getName());
                sb.append("=\"");
                sb.append(DOMWriter.getEscaped(String.valueOf(attribute.getValue())));
                sb.append("\"");
            }
            sb.append(hasChildren ? ">" : "/>");
            this.print(sb.toString());
        }

        private void endTag(Element element) {
            StringBuffer sb = new StringBuffer();
            sb.append("</");
            sb.append(element.getNodeName());
            sb.append(">");
            this.print(sb.toString());
        }

        private static void appendEscapedChar(StringBuffer buffer, char c) {
            String replacement = DOMWriter.getReplacement(c);
            if (replacement != null) {
                buffer.append('&');
                buffer.append(replacement);
                buffer.append(';');
            } else if (c == '\t' || c == '\n' || c == '\r' || c >= ' ') {
                buffer.append(c);
            }
        }

        private static String getEscaped(String s) {
            StringBuffer result = new StringBuffer(s.length() + 10);
            for (int i = 0; i < s.length(); ++i) {
                DOMWriter.appendEscapedChar(result, s.charAt(i));
            }
            return result.toString();
        }

        private static String getReplacement(char c) {
            switch (c) {
                case '<': {
                    return "lt";
                }
                case '>': {
                    return "gt";
                }
                case '\"': {
                    return "quot";
                }
                case '\'': {
                    return "apos";
                }
                case '&': {
                    return "amp";
                }
                case '\r': {
                    return "#x0D";
                }
                case '\n': {
                    return "#x0A";
                }
                case '\t': {
                    return "#x09";
                }
            }
            return null;
        }
    }
}

