/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin.rows;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.IContextPart;
import org.eclipse.pde.internal.ui.editor.plugin.rows.ExtensionAttributeRow;
import org.eclipse.pde.internal.ui.editor.text.PDETextHover;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TextAttributeRow
extends ExtensionAttributeRow {
    protected Text text;

    public TextAttributeRow(IContextPart part, ISchemaAttribute att) {
        super(part, att);
    }

    public TextAttributeRow(IContextPart part, IPluginAttribute att) {
        super(part, att);
    }

    @Override
    public void createContents(Composite parent, FormToolkit toolkit, int span) {
        super.createContents(parent, toolkit, span);
        this.createLabel(parent, toolkit);
        this.text = toolkit.createText(parent, "", 4);
        this.text.setLayoutData((Object)this.createGridData(span));
        this.text.addModifyListener(e -> {
            if (!this.blockNotification) {
                this.markDirty();
            }
            PDETextHover.updateHover(this.fIC, this.getHoverContent((Control)this.text));
        });
        this.text.setEditable(this.part.isEditable());
        PDETextHover.addHoverListenerToControl(this.fIC, (Control)this.text, this);
        this.createUITextFocusListener();
    }

    private void createUITextFocusListener() {
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                TextSelection selection = new TextSelection(1, 1);
                TextAttributeRow.this.part.getPage().getPDEEditor().getContributor().updateSelectableActions((ISelection)selection);
            }
        });
    }

    protected GridData createGridData(int span) {
        GridData gd = new GridData(span == 2 ? 768 : 256);
        gd.widthHint = 20;
        gd.horizontalSpan = span - 1;
        gd.horizontalIndent = 3;
        return gd;
    }

    @Override
    protected void update() {
        this.blockNotification = true;
        this.text.setText(this.getValue());
        this.blockNotification = false;
    }

    @Override
    public void commit() {
        if (this.dirty && this.input != null) {
            String value = this.text.getText();
            try {
                this.input.setAttribute(this.getName(), value);
                this.dirty = false;
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    @Override
    public void setFocus() {
        this.text.setFocus();
    }
}

