/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services;

import org.eclipse.acceleo.annotations.api.documentation.Documentation;
import org.eclipse.acceleo.annotations.api.documentation.Example;
import org.eclipse.acceleo.annotations.api.documentation.Param;
import org.eclipse.acceleo.annotations.api.documentation.ServiceProvider;

@ServiceProvider(value="Services available for prompting user for values using the console.")
public class PromptServices {
    @Documentation(value="Prompts for a String value with the given message.", params={@Param(name="message", value="The message displayed to the user")}, result="Prompts the user and return the input of the user as a String.", examples={@Example(expression="'Enter your name: '.promptString()", result="prompts the user")})
    public String promptString(String message) {
        return System.console().readLine(message, new Object[0]);
    }

    @Documentation(value="Prompts for a Integer value with the given message.", params={@Param(name="message", value="The message displayed to the user")}, result="Prompts the user and return the input of the user as an Integer.", examples={@Example(expression="'Enter your age: '.promptInteger()", result="prompts the user")})
    public Integer promptInteger(String message) {
        return Integer.valueOf(this.promptString(message));
    }

    @Documentation(value="Prompts for a Long value with the given message.", params={@Param(name="message", value="The message displayed to the user")}, result="Prompts the user and return the input of the user as an Long.", examples={@Example(expression="'Enter your age: '.promptLong()", result="prompts the user")})
    public Long promptLong(String message) {
        return Long.valueOf(this.promptString(message));
    }

    @Documentation(value="Prompts for a Float value with the given message.", params={@Param(name="message", value="The message displayed to the user")}, result="Prompts the user and return the input of the user as a Float.", examples={@Example(expression="'Enter your weight: '.promptFloat()", result="prompts the user")})
    public Float promptFloat(String message) {
        return Float.valueOf(this.promptString(message));
    }

    @Documentation(value="Prompts for a Double value with the given message.", params={@Param(name="message", value="The message displayed to the user")}, result="Prompts the user and return the input of the user as a Double.", examples={@Example(expression="'Enter your weight: '.promptDouble()", result="prompts the user")})
    public Double promptDouble(String message) {
        return Double.valueOf(this.promptString(message));
    }
}

