/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.ide.services.configurator;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.acceleo.query.AQLUtils;
import org.eclipse.acceleo.query.ide.QueryPlugin;
import org.eclipse.acceleo.query.services.configurator.IResourceSetConfigurator;
import org.eclipse.acceleo.query.services.configurator.IResourceSetConfiguratorDescriptor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.Platform;

public class ResourceSetConfiguratorRegistryListener
implements IRegistryEventListener {
    public static final String CLASS = "class";
    public static final String SERVICES_CONFIGURATOR_EXTENSION_POINT = "org.eclipse.acceleo.query.ide.resourceSetConfigurator";
    public static final String SERVICES_CONFIGURATOR_TAG_EXTENSION = "resourceSetConfigurators";
    public static final String SERVICES_CONFIGURATOR_ATTRIBUTE_CLASS = "class";
    private final Map<String, IResourceSetConfiguratorDescriptor> descriptors = new HashMap<String, IResourceSetConfiguratorDescriptor>();

    public void added(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            if (SERVICES_CONFIGURATOR_EXTENSION_POINT.equals(extension.getUniqueIdentifier())) {
                this.parseServicesConfiguratorExtension(extension);
            }
            ++n2;
        }
    }

    public void added(IExtensionPoint[] extensionPoints) {
    }

    public void parseInitialContributions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtension[] iExtensionArray = registry.getExtensionPoint(SERVICES_CONFIGURATOR_EXTENSION_POINT).getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.parseServicesConfiguratorExtension(extension);
            ++n2;
        }
    }

    public void removed(IExtension[] extensions) {
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configElements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
            int n3 = configElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IResourceSetConfiguratorDescriptor descriptor;
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (SERVICES_CONFIGURATOR_TAG_EXTENSION.equals(element.getName()) && (descriptor = this.descriptors.remove(element.getAttribute("class"))) != null) {
                    AQLUtils.unregisterResourceSetConfigurator((IResourceSetConfiguratorDescriptor)descriptor);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public void removed(IExtensionPoint[] extensionPoints) {
    }

    private void parseServicesConfiguratorExtension(IExtension extension) {
        IConfigurationElement[] configElements;
        IConfigurationElement[] iConfigurationElementArray = configElements = extension.getConfigurationElements();
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (SERVICES_CONFIGURATOR_TAG_EXTENSION.equals(element.getName())) {
                ExtensionServicesConfiguratorDescriptor descriptor = new ExtensionServicesConfiguratorDescriptor(element);
                this.descriptors.put(element.getAttribute("class"), descriptor);
                AQLUtils.registerResourceSetConfigurator((IResourceSetConfiguratorDescriptor)descriptor);
            }
            ++n2;
        }
    }

    public static class ExtensionServicesConfiguratorDescriptor
    implements IResourceSetConfiguratorDescriptor {
        private final IConfigurationElement element;
        private IResourceSetConfigurator configurator;

        public ExtensionServicesConfiguratorDescriptor(IConfigurationElement element) {
            this.element = element;
        }

        public IResourceSetConfigurator getResourceSetConfigurator() {
            if (this.configurator == null) {
                try {
                    this.configurator = (IResourceSetConfigurator)this.element.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    QueryPlugin.log((Exception)((Object)e), false);
                }
            }
            return this.configurator;
        }
    }
}

