/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IQueryEnvironmentListener;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.ServiceRegistrationResult;
import org.eclipse.acceleo.query.runtime.ServiceUtils;
import org.eclipse.acceleo.query.runtime.impl.EPackageProvider;
import org.eclipse.acceleo.query.runtime.lookup.basic.BasicLookupEngine;
import org.eclipse.acceleo.query.runtime.lookup.basic.CacheLookupEngine;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;

public class QueryEnvironment
implements IQueryEnvironment {
    protected BasicLookupEngine lookupEngine;
    private EPackageProvider ePackageProvider;
    private List<IQueryEnvironmentListener> listeners = new ArrayList<IQueryEnvironmentListener>();

    public QueryEnvironment() {
        this.ePackageProvider = new EPackageProvider();
        this.lookupEngine = new CacheLookupEngine(this);
    }

    @Override
    public ServiceRegistrationResult registerService(IService<?> service) {
        ServiceRegistrationResult result = this.getLookupEngine().registerService(service);
        if (!result.getRegistered().isEmpty()) {
            for (IQueryEnvironmentListener listener : this.getListeners()) {
                listener.serviceRegistered(result, service);
            }
        }
        return result;
    }

    @Override
    public void removeService(IService<?> service) {
        IService<?> removedService = this.getLookupEngine().removeService(service);
        if (removedService != null) {
            for (IQueryEnvironmentListener listener : this.getListeners()) {
                listener.serviceRemoved(removedService);
            }
        }
    }

    @Override
    public void registerEPackage(EPackage ePackage) {
        EPackage registeredEPackage = this.getEPackageProvider().registerPackage(ePackage);
        if (registeredEPackage != null) {
            for (IQueryEnvironmentListener listener : this.getListeners()) {
                listener.ePackageRegistered(ePackage);
            }
            Set<IService<?>> services = ServiceUtils.getServices(ePackage);
            ServiceUtils.registerServices(this, services);
        }
    }

    @Override
    public void removeEPackage(EPackage ePackage) {
        Collection<EPackage> ePackages = this.getEPackageProvider().removePackage(ePackage);
        for (EPackage ePkg : ePackages) {
            for (IQueryEnvironmentListener listener : this.getListeners()) {
                listener.ePackageRemoved(ePkg);
            }
        }
    }

    @Override
    public void registerCustomClassMapping(EClassifier eClassifier, Class<?> cls) {
        this.getEPackageProvider().registerCustomClassMapping(eClassifier, cls);
        for (IQueryEnvironmentListener listener : this.getListeners()) {
            listener.customClassMappingRegistered(eClassifier, cls);
        }
    }

    @Override
    public BasicLookupEngine getLookupEngine() {
        return this.lookupEngine;
    }

    @Override
    public EPackageProvider getEPackageProvider() {
        return this.ePackageProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addQueryEnvironmentListener(IQueryEnvironmentListener listener) {
        if (listener != null) {
            List<IQueryEnvironmentListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(listener);
            }
        } else {
            throw new IllegalArgumentException("IQueryEnvironmentListener can't be null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeQueryEnvironmentListener(IQueryEnvironmentListener listener) {
        if (listener != null) {
            List<IQueryEnvironmentListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<IQueryEnvironmentListener> getListeners() {
        ArrayList<IQueryEnvironmentListener> result;
        List<IQueryEnvironmentListener> list = this.listeners;
        synchronized (list) {
            result = new ArrayList<IQueryEnvironmentListener>(this.listeners);
        }
        return result;
    }

    @Override
    public boolean isRegisteredService(IService<?> service) {
        return this.getLookupEngine().isRegisteredService(service);
    }
}

