/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.profiler.presentation;

import java.net.URISyntaxException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.acceleo.AcceleoASTNode;
import org.eclipse.acceleo.Block;
import org.eclipse.acceleo.ExpressionStatement;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.TextStatement;
import org.eclipse.acceleo.aql.parser.AcceleoAstResult;
import org.eclipse.acceleo.aql.profiler.ProfileEntry;
import org.eclipse.acceleo.aql.profiler.ProfileResource;
import org.eclipse.acceleo.aql.profiler.ProfilerPackage;
import org.eclipse.acceleo.aql.profiler.editor.AcceleoEnvResourceFactory;
import org.eclipse.acceleo.aql.profiler.editor.coverage.CoverageHelper;
import org.eclipse.acceleo.aql.profiler.presentation.ProfilerEditorPlugin;
import org.eclipse.acceleo.aql.profiler.presentation.ProfilerOutlineContentProvider;
import org.eclipse.acceleo.aql.profiler.presentation.ProfilerSortAction;
import org.eclipse.acceleo.aql.profiler.presentation.ProfilerSortStatus;
import org.eclipse.acceleo.aql.profiler.provider.ProfilerItemProviderAdapterFactorySpec;
import org.eclipse.acceleo.query.ast.ASTNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.presentation.EcoreEditor;
import org.eclipse.emf.ecore.presentation.EcoreEditorPlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public final class ProfilerEditor
extends EcoreEditor {
    protected ProfilerSortStatus sortStatus = new ProfilerSortStatus();
    private AcceleoEnvResourceFactory acceleoEnvResourceFactory;
    private CoverageHelper coverageHelper;

    public ProfilerEditor() {
        ProfilerPackage.eINSTANCE.getName();
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ProfilerItemProviderAdapterFactorySpec());
    }

    public void createPages() {
        super.createPages();
        this.selectionViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object selected = ((TreeSelection)event.getSelection()).getFirstElement();
                AcceleoASTNode astNode = null;
                if (selected instanceof ProfileEntry && ((ProfileEntry)selected).getMonitored() instanceof AcceleoASTNode) {
                    astNode = (AcceleoASTNode)((ProfileEntry)selected).getMonitored();
                } else if (selected instanceof AcceleoASTNode) {
                    astNode = (AcceleoASTNode)selected;
                }
                if (astNode != null) {
                    try {
                        ProfilerEditor.this.selectInEditor(astNode);
                    }
                    catch (PartInitException e) {
                        ProfilerEditorPlugin.getPlugin().log((Object)e);
                    }
                    catch (URISyntaxException e) {
                        ProfilerEditorPlugin.getPlugin().log(e);
                    }
                }
            }
        });
        this.selectionViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                int ret = 0;
                if (e1 instanceof ProfileEntry && e2 instanceof ProfileEntry) {
                    ProfileEntry entry1 = (ProfileEntry)e1;
                    ProfileEntry entry2 = (ProfileEntry)e2;
                    switch (ProfilerEditor.this.sortStatus.getSortOrder()) {
                        case 0: {
                            ret = (int)(entry1.getCreationTime() - entry2.getCreationTime());
                            break;
                        }
                        case 1: {
                            ret = (int)(entry2.getDuration() - entry1.getDuration());
                            break;
                        }
                    }
                }
                return ret;
            }
        });
        this.selectionViewer.setContentProvider((IContentProvider)new ProfileEditorContentProvider((AdapterFactory)this.adapterFactory));
        this.selectionViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory){

            public String getText(Object object) {
                if (object instanceof Module) {
                    Module module = (Module)object;
                    return super.getText((Object)module) + " (coverage: " + ProfilerEditor.this.getCoverageHelper().computeUsage(module) + "%)";
                }
                return super.getText(object);
            }
        });
        IToolBarManager toolBarManager = this.getActionBars().getToolBarManager();
        toolBarManager.add((IAction)new ProfilerSortAction(this.sortStatus, this.selectionViewer));
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            class MyContentOutlinePage
            extends ContentOutlinePage {
                MyContentOutlinePage() {
                }

                public void createControl(Composite parent) {
                    super.createControl(parent);
                    ProfilerEditor.this.contentOutlineViewer = this.getTreeViewer();
                    ProfilerEditor.this.contentOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                    ProfilerEditor.this.contentOutlineViewer.setContentProvider((IContentProvider)new ProfilerOutlineContentProvider((AdapterFactory)ProfilerEditor.this.adapterFactory));
                    ProfilerEditor.this.contentOutlineViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)ProfilerEditor.this.adapterFactory));
                    ProfilerEditor.this.contentOutlineViewer.setInput((Object)ProfilerEditor.this.editingDomain.getResourceSet());
                    ProfilerEditor.this.createContextMenuFor((StructuredViewer)ProfilerEditor.this.contentOutlineViewer);
                    if (!ProfilerEditor.this.editingDomain.getResourceSet().getResources().isEmpty()) {
                        ProfilerEditor.this.contentOutlineViewer.setSelection((ISelection)StructuredSelection.EMPTY, true);
                    }
                }

                public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
                    super.makeContributions(menuManager, toolBarManager, statusLineManager);
                    ProfilerEditor.this.contentOutlineStatusLineManager = statusLineManager;
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    ProfilerEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }
            }
            this.contentOutlinePage = new MyContentOutlinePage();
            this.contentOutlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ProfilerEditor.this.handleContentOutlineSelection(event.getSelection());
                }
            });
        }
        return this.contentOutlinePage;
    }

    public void setStatusLineManager(ISelection selection) {
        IStatusLineManager statusLineManager = null;
        statusLineManager = this.currentViewer != null && this.currentViewer == this.contentOutlineViewer ? this.contentOutlineStatusLineManager : this.getActionBars().getStatusLineManager();
        if (statusLineManager != null) {
            if (selection instanceof IStructuredSelection) {
                List collection = ((IStructuredSelection)selection).toList();
                switch (collection.size()) {
                    case 0: {
                        statusLineManager.setMessage(ProfilerEditor.getString("_UI_NoObjectSelected"));
                        break;
                    }
                    case 1: {
                        String text = new AdapterFactoryItemDelegator((AdapterFactory)this.adapterFactory).getText(collection.iterator().next());
                        statusLineManager.setMessage(ProfilerEditor.getString("_UI_SingleObjectSelected", text));
                        break;
                    }
                    default: {
                        Iterator it = collection.iterator();
                        double percentage = 0.0;
                        long duration = 0L;
                        long count = 0L;
                        while (it.hasNext()) {
                            Object select = it.next();
                            if (!(select instanceof ProfileEntry)) continue;
                            ProfileEntry entry = (ProfileEntry)select;
                            percentage += (double)entry.getPercentage();
                            duration += entry.getDuration();
                            count += (long)entry.getCount();
                        }
                        DecimalFormat format = new DecimalFormat();
                        ((NumberFormat)format).setMaximumIntegerDigits(3);
                        ((NumberFormat)format).setMaximumFractionDigits(2);
                        String statusString = Integer.toString(collection.size()) + " [" + format.format(percentage) + "% / " + duration + "ms / " + count + " times]";
                        statusLineManager.setMessage(ProfilerEditor.getString("_UI_MultiObjectSelected", statusString));
                        break;
                    }
                }
            } else {
                statusLineManager.setMessage("");
            }
        }
    }

    private static String getString(String key) {
        return ProfilerEditorPlugin.INSTANCE.getString(key);
    }

    private static String getString(String key, Object s1) {
        return EcoreEditorPlugin.INSTANCE.getString(key, new Object[]{s1});
    }

    public void setCurrentViewer(Viewer viewer) {
        if (this.currentViewer != viewer) {
            if (this.selectionChangedListener == null) {
                this.selectionChangedListener = new ChangementListener();
            }
            if (this.currentViewer != null) {
                this.currentViewer.removeSelectionChangedListener(this.selectionChangedListener);
            }
            if (viewer != null) {
                viewer.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.currentViewer = viewer;
            if (this.currentViewer == null) {
                this.setSelection((ISelection)StructuredSelection.EMPTY);
            } else {
                this.setSelection(this.currentViewer.getSelection());
            }
        }
    }

    protected boolean showOutlineView() {
        return true;
    }

    public void init(IEditorSite site, IEditorInput editorInput) {
        IFile startFile;
        super.init(site, editorInput);
        this.createModel();
        URI startURI = URI.createURI((String)this.getProfileResource().getStartResource(), (boolean)true);
        if (startURI.isPlatformResource()) {
            startFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(startURI.toPlatformString(true)));
        } else {
            java.net.URI uri = java.net.URI.create(startURI.toString());
            IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(uri);
            if (files.length != 0) {
                startFile = files[0];
            } else {
                MessageDialog.openError((Shell)this.getEditorSite().getShell(), (String)"Error", (String)("Couldn't find workspace file for: " + String.valueOf(startURI)));
                startFile = null;
            }
        }
        if (startFile != null) {
            IProject project = startFile.getProject();
            this.acceleoEnvResourceFactory = new AcceleoEnvResourceFactory(project);
            this.getEditingDomain().getResourceSet().getResourceFactoryRegistry().getProtocolToFactoryMap().put("acceleoenv", this.acceleoEnvResourceFactory);
        }
    }

    private CoverageHelper getCoverageHelper() {
        if (this.coverageHelper == null) {
            this.coverageHelper = new CoverageHelper(this.getProfileResource());
        }
        return this.coverageHelper;
    }

    private ProfileResource getProfileResource() {
        for (Resource resource : this.getEditingDomain().getResourceSet().getResources()) {
            if (resource.getContents().isEmpty() || !(resource.getContents().get(0) instanceof ProfileResource)) continue;
            return (ProfileResource)resource.getContents().get(0);
        }
        return null;
    }

    private void selectInEditor(AcceleoASTNode astNode) throws PartInitException, URISyntaxException {
        Module module;
        IFile sourceFile;
        Resource eResource = astNode.eResource();
        if (this.acceleoEnvResourceFactory != null && eResource != null && !eResource.getContents().isEmpty() && eResource.getContents().get(0) instanceof Module && (sourceFile = this.acceleoEnvResourceFactory.getSourceFile(module = (Module)eResource.getContents().get(0))) != null) {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            AcceleoAstResult ast = module.getAst();
            int start = ast.getStartPosition((ASTNode)astNode);
            int end = ast.getEndPosition((ASTNode)astNode);
            IEditorPart editor = IDE.openEditor((IWorkbenchPage)page, (IFile)sourceFile);
            if (editor instanceof TextEditor) {
                TextEditor textEditor = (TextEditor)editor;
                this.getCoverageHelper().attach((ITextEditor)textEditor, module);
                if (!(astNode instanceof Module)) {
                    textEditor.selectAndReveal(start, end - start);
                }
            }
        }
    }

    protected void handleChangedResources() {
        if (this.changedResources.contains(this.getProfileResource().eResource())) {
            if (this.acceleoEnvResourceFactory != null) {
                this.acceleoEnvResourceFactory.init();
            }
            ArrayList<Resource> moduleResources = new ArrayList<Resource>();
            for (Resource resource : this.editingDomain.getResourceSet().getResources()) {
                if (resource.getContents().isEmpty() || !(resource.getContents().get(0) instanceof Module)) continue;
                moduleResources.add(resource);
            }
            this.editingDomain.getResourceSet().getResources().removeAll(moduleResources);
            if (this.coverageHelper != null) {
                this.coverageHelper.clearAnnotations();
                this.coverageHelper = null;
            }
        }
        super.handleChangedResources();
    }

    public void dispose() {
        if (this.acceleoEnvResourceFactory != null) {
            this.acceleoEnvResourceFactory.dispose();
        }
        if (this.coverageHelper != null) {
            this.coverageHelper.clearAnnotations();
        }
        super.dispose();
    }

    private final class ChangementListener
    implements ISelectionChangedListener {
        private ChangementListener() {
        }

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            ProfilerEditor.this.setSelection(selectionChangedEvent.getSelection());
            if (ProfilerEditor.this.currentViewer != ProfilerEditor.this.contentOutlineViewer && ProfilerEditor.this.contentOutlineViewer != null && !ProfilerEditor.this.contentOutlineViewer.getControl().isDisposed()) {
                if (ProfilerEditor.this.contentOutlineViewer.getContentProvider() == null) {
                    ProfilerEditor.this.contentOutlineViewer.setContentProvider((IContentProvider)new ProfilerOutlineContentProvider((AdapterFactory)ProfilerEditor.this.adapterFactory));
                }
                ProfilerEditor.this.contentOutlineViewer.setInput(((TreeSelection)selectionChangedEvent.getSelection()).getFirstElement());
            }
        }
    }

    private final class ProfileEditorContentProvider
    extends AdapterFactoryContentProvider {
        private ProfileEditorContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Object[] getChildren(Object object) {
            if (object instanceof ProfileEntry) {
                return this.internalGetChildren((ProfileEntry)object).toArray();
            }
            return super.getChildren(object);
        }

        private Collection<ProfileEntry> internalGetChildren(ProfileEntry profileEntry) {
            ArrayList<ProfileEntry> children = new ArrayList<ProfileEntry>();
            for (ProfileEntry child : profileEntry.getCallees()) {
                if (this.isSkipped(child.getMonitored())) {
                    children.addAll(this.internalGetChildren(child));
                    continue;
                }
                children.add(child);
            }
            return children;
        }

        private boolean isSkipped(Object object) {
            return object instanceof TextStatement || object instanceof ExpressionStatement || object instanceof Block;
        }

        public Object[] getElements(Object object) {
            return this.getChildren(object);
        }
    }
}

